/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQueryUpdate;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SimpleUpdateQueryPlan
implements NonSelectQueryPlan {
    private final SqmUpdateStatement<?> sqmUpdate;
    private final DomainParameterXref domainParameterXref;
    private JdbcOperationQueryUpdate jdbcUpdate;
    private FromClauseAccess tableGroupAccess;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<List<JdbcParameter>>>> jdbcParamsXref;
    private Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParamMappingTypeResolutions;

    public SimpleUpdateQueryPlan(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref) {
        this.sqmUpdate = sqmUpdate;
        this.domainParameterXref = domainParameterXref;
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        BulkOperationCleanupAction.schedule(executionContext.getSession(), this.sqmUpdate);
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcOperationQueryUpdate> updateTranslator = null;
        if (this.jdbcUpdate == null) {
            updateTranslator = this.createUpdateTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getRuntimeMetamodels().getMappingMetamodel(), this.tableGroupAccess::findTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return SimpleUpdateQueryPlan.this.sqmParamMappingTypeResolutions.get(parameter);
            }
        }, session);
        if (this.jdbcUpdate != null && !this.jdbcUpdate.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            updateTranslator = this.createUpdateTranslator(executionContext);
        }
        if (updateTranslator != null) {
            this.jdbcUpdate = updateTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        }
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcUpdate, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext));
    }

    private SqlAstTranslator<JdbcOperationQueryUpdate> createUpdateTranslator(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator<UpdateStatement> translator = translatorFactory.createSimpleUpdateTranslator(this.sqmUpdate, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), factory);
        SqmTranslation<UpdateStatement> sqmInterpretation = translator.translate();
        this.tableGroupAccess = sqmInterpretation.getFromClauseAccess();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        this.sqmParamMappingTypeResolutions = sqmInterpretation.getSqmParameterMappingModelTypeResolutions();
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildUpdateTranslator(factory, sqmInterpretation.getSqlAst());
    }
}

