/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.NaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.stat.spi.StatisticsImplementor;

public abstract class AbstractNaturalIdLoader<T>
implements NaturalIdLoader<T> {
    private final NaturalIdMapping naturalIdMapping;
    private final EntityMappingType entityDescriptor;

    public AbstractNaturalIdLoader(NaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        this.naturalIdMapping = naturalIdMapping;
        this.entityDescriptor = entityDescriptor;
    }

    protected EntityMappingType entityDescriptor() {
        return this.entityDescriptor;
    }

    protected NaturalIdMapping naturalIdMapping() {
        return this.naturalIdMapping;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor();
    }

    @Override
    public T load(Object naturalIdValue, NaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        return (T)this.selectByNaturalId(this.naturalIdMapping().normalizeInput(naturalIdValue), options, (tableGroup, creationState) -> this.entityDescriptor.createDomainResult(new NavigablePath(this.entityDescriptor().getRootPathName()), (TableGroup)tableGroup, null, (DomainResultCreationState)creationState), AbstractNaturalIdLoader::visitFetches, statsEnabled -> statsEnabled != false ? System.nanoTime() : -1L, (result, startToken) -> {
            if (startToken > 0L) {
                session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
            }
        }, session);
    }

    protected <L> L selectByNaturalId(Object bindValue, NaturalIdLoadOptions options, BiFunction<TableGroup, LoaderSqlAstCreationState, DomainResult<?>> domainResultProducer, LoaderSqlAstCreationState.FetchProcessor fetchProcessor, Function<Boolean, Long> statementStartHandler, BiConsumer<Object, Long> statementCompletionHandler, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        LockOptions lockOptions = options.getLockOptions() != null ? options.getLockOptions() : LockOptions.NONE;
        NavigablePath entityPath = new NavigablePath(this.entityDescriptor.getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), lockOptions, fetchProcessor, true, LoadQueryInfluencers.NONE, sessionFactory);
        TableGroup rootTableGroup = this.entityDescriptor.createRootTableGroup(true, entityPath, null, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        DomainResult<?> domainResult = domainResultProducer.apply(rootTableGroup, sqlAstCreationState);
        SelectStatement sqlSelect = new SelectStatement(rootQuerySpec, Collections.singletonList(domainResult));
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.naturalIdMapping.getJdbcTypeCount());
        this.applyNaturalIdRestriction(bindValue, rootTableGroup, rootQuerySpec::applyPredicate, jdbcParamBindings::addBinding, sqlAstCreationState, session);
        SimpleQueryOptions queryOptions = new SimpleQueryOptions(lockOptions, false);
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlSelect).translate(jdbcParamBindings, queryOptions);
        StatisticsImplementor statistics = sessionFactory.getStatistics();
        Long startToken = statementStartHandler.apply(statistics.isStatisticsEnabled());
        List<Object> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new NaturalIdLoaderWithOptionsExecutionContext(session, queryOptions), row -> row[0], ListResultsConsumer.UniqueSemantic.FILTER);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Loading by natural-id returned more that one row : %s", this.entityDescriptor.getEntityName()));
        }
        Object result = results.isEmpty() ? null : results.get(0);
        statementCompletionHandler.accept(result, startToken);
        return (L)result;
    }

    protected abstract void applyNaturalIdRestriction(Object var1, TableGroup var2, Consumer<Predicate> var3, BiConsumer<JdbcParameter, JdbcParameterBinding> var4, LoaderSqlAstCreationState var5, SharedSessionContractImplementor var6);

    protected Expression resolveColumnReference(TableGroup rootTableGroup, SelectableMapping selectableMapping, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        TableReference tableReference = rootTableGroup.getTableReference(rootTableGroup.getNavigablePath(), selectableMapping.getContainingTableExpression());
        if (tableReference == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Unable to locate TableReference for `%s` : %s", selectableMapping.getContainingTableExpression(), rootTableGroup));
        }
        return sqlExpressionResolver.resolveSqlExpression(tableReference, selectableMapping);
    }

    @Override
    public Object resolveNaturalIdToId(Object naturalIdValue, SharedSessionContractImplementor session) {
        return this.selectByNaturalId(this.naturalIdMapping().normalizeInput(naturalIdValue), NaturalIdLoadOptions.NONE, (tableGroup, creationState) -> this.entityDescriptor.getIdentifierMapping().createDomainResult(tableGroup.getNavigablePath().append("{id}"), (TableGroup)tableGroup, null, (DomainResultCreationState)creationState), AbstractNaturalIdLoader::visitFetches, statsEnabled -> statsEnabled != false ? System.nanoTime() : -1L, (result, startToken) -> {
            if (startToken > 0L) {
                session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
            }
        }, session);
    }

    @Override
    public Object resolveIdToNaturalId(Object id, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor(), Collections.singletonList(this.naturalIdMapping()), this.entityDescriptor().getIdentifierMapping(), null, 1, session.getLoadQueryInfluencers(), LockOptions.NONE, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, this.entityDescriptor().getIdentifierMapping(), jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlSelect).translate(jdbcParamBindings, QueryOptions.NONE);
        List<Object> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new NoCallbackExecutionContext(session), row -> {
            assert (row.length == 1);
            return row[0];
        }, ListResultsConsumer.UniqueSemantic.FILTER);
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new HibernateException(String.format("Resolving id to natural-id returned more that one row : %s #%s", this.entityDescriptor().getEntityName(), id));
        }
        return results.get(0);
    }

    private static ImmutableFetchList visitFetches(FetchParent fetchParent, LoaderSqlAstCreationState creationState) {
        FetchableContainer fetchableContainer = fetchParent.getReferencedMappingContainer();
        int size = fetchableContainer.getNumberOfFetchables();
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(fetchableContainer);
        for (int i = 0; i < size; ++i) {
            Fetchable fetchable = fetchableContainer.getFetchable(i);
            NavigablePath navigablePath = fetchParent.resolveNavigablePath(fetchable);
            Fetch fetch = fetchParent.generateFetchableFetch(fetchable, navigablePath, fetchable.getMappedFetchOptions().getTiming(), true, null, creationState);
            fetches.add(fetch);
        }
        return fetches.build();
    }

    private static class NaturalIdLoaderWithOptionsExecutionContext
    extends BaseExecutionContext {
        private final Callback callback;
        private final QueryOptions queryOptions;

        public NaturalIdLoaderWithOptionsExecutionContext(SharedSessionContractImplementor session, QueryOptions queryOptions) {
            super(session);
            this.queryOptions = queryOptions;
            this.callback = new CallbackImpl();
        }

        @Override
        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        @Override
        public Callback getCallback() {
            return this.callback;
        }
    }
}

