/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.i18n;

import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.providers.ProcessingException;
import io.smallrye.reactive.messaging.providers.WeavingException;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;

public class ProviderExceptions_$bundle
implements ProviderExceptions,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ProviderExceptions_$bundle INSTANCE = new ProviderExceptions_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ProviderExceptions_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String processingException$str() {
        return "%s";
    }

    @Override
    public final ProcessingException processingException(String methodAsString, Throwable cause) {
        ProcessingException result = new ProcessingException(String.format(this.getLoggingLocale(), this.processingException$str(), methodAsString), cause);
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String illegalArgumentForGenericParameterType$str() {
        return "SRMSG00001: Method %s only has %d so parameter with index %d cannot be retrieved";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForGenericParameterType(Method method, int length, int index) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForGenericParameterType$str(), method, length, index));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForAnnotationNullOrBlank$str() {
        return "SRMSG00002: Invalid method annotated with %s: %s - value is blank or null";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForAnnotationNullOrBlank(String annotation, String annotationTarget) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForAnnotationNullOrBlank$str(), annotation, annotationTarget));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateExceptionForValidate$str() {
        return "SRMSG00003: Unknown shape: %s";
    }

    @Override
    public final IllegalStateException illegalStateExceptionForValidate(Shape shape) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateExceptionForValidate$str(), shape));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForValidateProcessor$str() {
        return "SRMSG00004: Invalid method annotated with @Outgoing and @Incoming %s - one parameter expected";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForValidateProcessor(String methodAsString) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForValidateProcessor$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateForValidateProcessor$str() {
        return "SRMSG00005: Unsupported acknowledgement policy - POST_PROCESSING not supported when producing messages for %s";
    }

    @Override
    public final IllegalStateException illegalStateForValidateProcessor(String methodAsString) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateForValidateProcessor$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String definitionExceptionUnsupported$str() {
        return "SRMSG00006: Invalid method annotated with %s: %s - The @Acknowledgment annotation is only supported for method annotated with @Incoming";
    }

    @Override
    public final DefinitionException definitionExceptionUnsupported(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionExceptionUnsupported$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalArgumentForUnsupportedShape$str() {
        return "SRMSG00007: Unsupported shape %s for method %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForUnsupportedShape(Shape shape, String methodAsString) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForUnsupportedShape$str(), shape, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForProcessorShape$str() {
        return "SRMSG00008: Expected a Processor shape, received a %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForProcessorShape(Shape shape) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForProcessorShape$str(), shape));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForInitialize$str() {
        return "SRMSG00009: Invalid Processor - unsupported signature for %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForInitialize(String methodAsString) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForInitialize$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForUnexpectedProduction$str() {
        return "SRMSG00010: Unexpected production type: %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForUnexpectedProduction(MediatorConfiguration.Production production) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForUnexpectedProduction$str(), production));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForPublisherShape$str() {
        return "SRMSG00011: Expected a Publisher shape, received a %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForPublisherShape(Shape shape) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForPublisherShape$str(), shape));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForUnexpectedConsumption$str() {
        return "SRMSG00012: Unexpected consumption type: %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForUnexpectedConsumption(MediatorConfiguration.Consumption consumption) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForUnexpectedConsumption$str(), consumption));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForSubscriberShape$str() {
        return "SRMSG00013: Expected a Subscriber shape, received a %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForSubscriberShape(Shape shape) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForSubscriberShape$str(), shape));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String weavingForIncoming$str() {
        return "SRMSG00014: %s";
    }

    @Override
    public final WeavingException weavingForIncoming(List<String> incoming, Throwable cause) {
        WeavingException result = new WeavingException(String.format(this.getLoggingLocale(), this.weavingForIncoming$str(), incoming), cause);
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateExceptionForSubscriberOrSubscriberBuilder$str() {
        return "SRMSG00015: Invalid return type: %s - expected a Flow.Subscriber, org.reactivestreams.Subscriber or a SubscriberBuilder";
    }

    @Override
    public final IllegalStateException illegalStateExceptionForSubscriberOrSubscriberBuilder(String resultClassName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateExceptionForSubscriberOrSubscriberBuilder$str(), resultClassName));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String runtimeForFailedWorker$str() {
        return "SRMSG00016: Failed to create Worker for %s";
    }

    @Override
    public final RuntimeException runtimeForFailedWorker(String workerName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.runtimeForFailedWorker$str(), workerName));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForFailedWorker$str() {
        return "SRMSG00017: @Blocking referred to invalid worker name.";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForFailedWorker() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForFailedWorker$str(), new Object[0]));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateForStream$str() {
        return "SRMSG00018: Unable to find a stream with the name %s, available streams are: %s";
    }

    @Override
    public final IllegalStateException illegalStateForStream(String name, Set<String> valid) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateForStream$str(), name, valid));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incomingNotFoundForEmitter1$str() {
        return "SRMSG00019: Unable to connect an emitter with the channel `%s`";
    }

    @Override
    public final DefinitionException incomingNotFoundForEmitter(String name) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.incomingNotFoundForEmitter1$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String emitterWithoutChannelAnnotation$str() {
        return "SRMSG00020: Missing @Channel qualifier for + `%s`";
    }

    @Override
    public final DefinitionException emitterWithoutChannelAnnotation(InjectionPoint injectionPoint) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.emitterWithoutChannelAnnotation$str(), injectionPoint));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalArgumentForDefaultBuffer$str() {
        return "SRMSG00021: The default buffer size must be strictly positive";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForDefaultBuffer() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForDefaultBuffer$str(), new Object[0]));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForBackPressure$str() {
        return "SRMSG00022: Invalid back-pressure strategy: %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForBackPressure(OnOverflow.Strategy overFlowStrategy) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForBackPressure$str(), overFlowStrategy));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForNullValue$str() {
        return "SRMSG00023: `null` is not a valid value";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForNullValue() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForNullValue$str(), new Object[0]));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incomingNotFoundForEmitter0$str() {
        return "SRMSG00024: The emitter encountered a failure";
    }

    @Override
    public final IllegalStateException incomingNotFoundForEmitter(Throwable throwable) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.incomingNotFoundForEmitter0$str(), new Object[0]), throwable);
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateForDownstreamCancel$str() {
        return "SRMSG00025: The downstream has cancelled the consumption";
    }

    @Override
    public final IllegalStateException illegalStateForDownstreamCancel() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateForDownstreamCancel$str(), new Object[0]));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateForEmitterWhileEmitting$str() {
        return "SRMSG00026: The emitter encountered a failure while emitting";
    }

    @Override
    public final IllegalStateException illegalStateForEmitterWhileEmitting(Throwable throwable) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateForEmitterWhileEmitting$str(), new Object[0]), throwable);
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noEmitterForChannel$str() {
        return "SRMSG00027: Cannot send a message, there is no subscriber found for the channel '%s'. Before calling `send`, you can verify there is a subscriber and demands using `emitter.hasRequests()`. Alternatively, you can add `@OnOverflow(OnOverflow.Strategy.DROP)` on the emitter.";
    }

    @Override
    public final IllegalStateException noEmitterForChannel(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noEmitterForChannel$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateForCancelledSubscriber$str() {
        return "SRMSG00028: The subscription to %s has been cancelled";
    }

    @Override
    public final IllegalStateException illegalStateForCancelledSubscriber(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateForCancelledSubscriber$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForException$str() {
        return "SRMSG00029: `%s` is not a valid exception";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForException(String val) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForException$str(), val));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateInsufficientDownstreamRequests$str() {
        return "SRMSG00034: Insufficient downstream requests to emit item";
    }

    @Override
    public final IllegalStateException illegalStateInsufficientDownstreamRequests() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateInsufficientDownstreamRequests$str(), new Object[0]));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateUnhandledType$str() {
        return "SRMSG00035: found an unhandled type: %s";
    }

    @Override
    public final IllegalStateException illegalStateUnhandledType(Type type) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateUnhandledType$str(), type));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentMissingAssignment$str() {
        return "SRMSG00036: missing assignment type for type variable %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentMissingAssignment(Type type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentMissingAssignment$str(), type));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateUnexpectedGenericInterface$str() {
        return "SRMSG00037: Unexpected generic interface type found: %s";
    }

    @Override
    public final IllegalStateException illegalStateUnexpectedGenericInterface(Type type) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateUnexpectedGenericInterface$str(), type));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentTypeToString$str() {
        return "SRMSG00038: %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentTypeToString(String typeName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentTypeToString$str(), typeName));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nameMustBeSet$str() {
        return "SRMSG00039: `name` must be set";
    }

    @Override
    public final IllegalArgumentException nameMustBeSet() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nameMustBeSet$str(), new Object[0]));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationForNotNull$str() {
        return "SRMSG00040: %s must not be `null`";
    }

    @Override
    public final IllegalArgumentException validationForNotNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationForNotNull$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationForNotEmpty$str() {
        return "SRMSG00041: %s must not be `empty`";
    }

    @Override
    public final IllegalArgumentException validationForNotEmpty(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationForNotEmpty$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validationForContainsNull$str() {
        return "SRMSG00042: %s must not contain a `null` element";
    }

    @Override
    public final IllegalArgumentException validationForContainsNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validationForContainsNull$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String validateIsTrue$str() {
        return "SRMSG00043: %s";
    }

    @Override
    public final IllegalArgumentException validateIsTrue(String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validateIsTrue$str(), value));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentInvalidChannelConfiguration$str() {
        return "SRMSG00044: Invalid channel configuration -  the `channel-name` attribute cannot be used in configuration (channel `%s`)";
    }

    @Override
    public final IllegalArgumentException illegalArgumentInvalidChannelConfiguration(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentInvalidChannelConfiguration$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchElementForAttribute$str() {
        return "SRMSG00045: Cannot find attribute `%s` for channel `%s`. Has been tried: % and %s";
    }

    @Override
    public final NoSuchElementException noSuchElementForAttribute(String propertyName, String name, String channelKey, String connectorKey) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.noSuchElementForAttribute$str(), propertyName, name, channelKey, connectorKey));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForAnnotationNonEmpty$str() {
        return "SRMSG00046: %ss must contain a non-empty array of %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForAnnotationNonEmpty(String annotation, String annotationTarget) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForAnnotationNonEmpty$str(), annotation, annotationTarget));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String definitionNoParamOnSubscriber$str() {
        return "SRMSG00047: Invalid method annotated with %s: %s - when returning a Subscriber or a SubscriberBuilder, no parameters are expected";
    }

    @Override
    public final DefinitionException definitionNoParamOnSubscriber(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionNoParamOnSubscriber$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionSubscriberTypeParam$str() {
        return "SRMSG00048: Invalid method annotated with %s: %s - the returned Subscriber must declare a type parameter";
    }

    @Override
    public final DefinitionException definitionSubscriberTypeParam(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionSubscriberTypeParam$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionOnParam$str() {
        return "SRMSG00049: Invalid method annotated with %s: %s - when returning a %s, one parameter is expected";
    }

    @Override
    public final DefinitionException definitionOnParam(String annotation, String methodAsString, String returnType) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionOnParam$str(), annotation, methodAsString, returnType));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionUnsupportedSignature$str() {
        return "SRMSG00050: Invalid method annotated with %s: %s - Unsupported signature";
    }

    @Override
    public final DefinitionException definitionUnsupportedSignature(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionUnsupportedSignature$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedSynchronousSignature$str() {
        return "SRMSG00051: Invalid method annotated with @Incoming: %s - The signature is not supported. The method consumes a `Message`, so the returned type must be `CompletionStage<Void>` or `Uni<Void>`.";
    }

    @Override
    public final DefinitionException unsupportedSynchronousSignature(String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.unsupportedSynchronousSignature$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionNotVoid$str() {
        return "SRMSG00052: Invalid method annotated with %s: %s - the method must not be `void`";
    }

    @Override
    public final DefinitionException definitionNotVoid(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionNotVoid$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionNoParametersExpected$str() {
        return "SRMSG00053: Invalid method annotated with %s: %s - no parameters expected";
    }

    @Override
    public final DefinitionException definitionNoParametersExpected(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionNoParametersExpected$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionMustDeclareParam$str() {
        return "SRMSG00054: Invalid method annotated with %s: %s - the returned %s must declare a type parameter";
    }

    @Override
    public final DefinitionException definitionMustDeclareParam(String annotation, String methodAsString, String returnClass) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionMustDeclareParam$str(), annotation, methodAsString, returnClass));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionMustNotHaveParams$str() {
        return "SRMSG00055: Invalid method annotated with %s: %s - the method must not have parameters";
    }

    @Override
    public final DefinitionException definitionMustNotHaveParams(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionMustNotHaveParams$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionExpectedTwoParams$str() {
        return "SRMSG00056: Invalid method annotated with %s: %s - Expected 2 type parameters for the returned Processor";
    }

    @Override
    public final DefinitionException definitionExpectedTwoParams(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionExpectedTwoParams$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionExpectedReturnedParam$str() {
        return "SRMSG00057: Invalid method annotated with %s: %s - Expected a type parameter in the returned %s";
    }

    @Override
    public final DefinitionException definitionExpectedReturnedParam(String annotation, String methodAsString, String returnClass) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionExpectedReturnedParam$str(), annotation, methodAsString, returnClass));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionExpectedConsumedParam$str() {
        return "SRMSG00058: Invalid method annotated with %s: %s - Expected a type parameter for the consumed  %s";
    }

    @Override
    public final DefinitionException definitionExpectedConsumedParam(String annotation, String methodAsString, String returnClass) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionExpectedConsumedParam$str(), annotation, methodAsString, returnClass));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionAutoAckNotSupported$str() {
        return "SRMSG00059: Invalid method annotated with %s: %s - Automatic post-processing acknowledgment is not supported.";
    }

    @Override
    public final DefinitionException definitionAutoAckNotSupported(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionAutoAckNotSupported$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionManualAckNotSupported$str() {
        return "SRMSG00060: Invalid method annotated with %s: %s - Consuming a stream of payload is not supported with MANUAL acknowledgment. Use a Publisher<Message<I>> or PublisherBuilder<Message<I>> instead.";
    }

    @Override
    public final DefinitionException definitionManualAckNotSupported(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionManualAckNotSupported$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionProduceConsume$str() {
        return "SRMSG00061: Invalid method annotated with %s: %s - If the method produces a %s, it needs to consume the same type.";
    }

    @Override
    public final DefinitionException definitionProduceConsume(String annotation, String methodAsString, String expectedType) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionProduceConsume$str(), annotation, methodAsString, expectedType));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionMergeOnlyIncoming$str() {
        return "SRMSG00062: Invalid method annotated with %s: %s - The @Merge annotation is only supported for method annotated with @Incoming";
    }

    @Override
    public final DefinitionException definitionMergeOnlyIncoming(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionMergeOnlyIncoming$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionBroadcastOnlyOutgoing$str() {
        return "SRMSG00063: Invalid method annotated with %s: %s - The @Broadcast annotation is only supported for method annotated with @Outgoing";
    }

    @Override
    public final DefinitionException definitionBroadcastOnlyOutgoing(String annotation, String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionBroadcastOnlyOutgoing$str(), annotation, methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionBlockingOnlyIndividual$str() {
        return "SRMSG00064: Invalid method annotated with @Blocking: %s - The @Blocking annotation is only supported for methods returning `void` (@Incoming only), a `Message` or a payload";
    }

    @Override
    public final DefinitionException definitionBlockingOnlyIndividual(String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionBlockingOnlyIndividual$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionBlockingOnlyIndividualParam$str() {
        return "SRMSG00065: Invalid method annotated with @Blocking: %s - The @Blocking annotation is only supported for methods consuming an individual Message or payload like `consume(String s)` or `consume(Message<String> s)";
    }

    @Override
    public final DefinitionException definitionBlockingOnlyIndividualParam(String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionBlockingOnlyIndividualParam$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalBlockingSignature$str() {
        return "SRMSG00066: Invalid method annotated with @Blocking: %s - no @Incoming or @Outgoing present";
    }

    @Override
    public final IllegalArgumentException illegalBlockingSignature(String methodAsString) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalBlockingSignature$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentForWorkerConfigKey$str() {
        return "SRMSG00067: Invalid method annotated with %s: %s - %s was not defined";
    }

    @Override
    public final IllegalArgumentException illegalArgumentForWorkerConfigKey(String annotation, String annotationTarget, String workerConfigKey) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentForWorkerConfigKey$str(), annotation, annotationTarget, workerConfigKey));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullPointerOnInvokeBlocking$str() {
        return "SRMSG00068: The operation %s has returned null";
    }

    @Override
    public final NullPointerException nullPointerOnInvokeBlocking(String methodAsString) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.nullPointerOnInvokeBlocking$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentChannelConnectorConfiguration$str() {
        return "SRMSG00071: Invalid channel configuration -  the `connector` attribute must be set for channel `%s`";
    }

    @Override
    public final IllegalArgumentException illegalArgumentChannelConnectorConfiguration(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentChannelConnectorConfiguration$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentUnknownConnector$str() {
        return "SRMSG00072: Unknown connector for `%s`.";
    }

    @Override
    public final IllegalArgumentException illegalArgumentUnknownConnector(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentUnknownConnector$str(), name));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentInvalidConfiguration$str() {
        return "SRMSG00073: Invalid configuration, the following channel names cannot be used for both incoming and outgoing: %s";
    }

    @Override
    public final DeploymentException deploymentInvalidConfiguration(Set<String> sources) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.deploymentInvalidConfiguration$str(), sources));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalStateRetrieveConfig$str() {
        return "SRMSG00074: Unable to retrieve the config";
    }

    @Override
    public final IllegalStateException illegalStateRetrieveConfig() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateRetrieveConfig$str(), new Object[0]));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEmitterOfMessage$str() {
        return "SRMSG00075: Invalid Emitter injection found for `%s`. Injecting an `Emitter<Message<T>>` is invalid. You can use an `Emitter<T>` to send instances of `T` and `Message<T>`.";
    }

    @Override
    public final DefinitionException invalidEmitterOfMessage(InjectionPoint ip) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.invalidEmitterOfMessage$str(), ip));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidRawEmitter$str() {
        return "SRMSG00076: Invalid Emitter injection found for  `%s`. The Emitter expected to be parameterized with the emitted type, such as Emitter<String>.";
    }

    @Override
    public final DefinitionException invalidRawEmitter(InjectionPoint ip) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.invalidRawEmitter$str(), ip));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noConverterForType$str() {
        return "SRMSG00077: No converter for type `%s`";
    }

    @Override
    public final NoSuchElementException noConverterForType(Class<?> propertyType) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.noConverterForType$str(), propertyType));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String converterReturnedNull$str() {
        return "SRMSG00078: Converter `%s` returned null for value `%s`";
    }

    @Override
    public final NoSuchElementException converterReturnedNull(Converter<?> converter, String value) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.converterReturnedNull$str(), converter, value));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configNotOfType$str() {
        return "SRMSG00079: The config is not of type `%s`";
    }

    @Override
    public final IllegalArgumentException configNotOfType(Class<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.configNotOfType$str(), type));
        ProviderExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String definitionCompletionStageOfVoid$str() {
        return "SRMSG00080: Invalid method annotated with @Incoming: %s - when returning a CompletionStage, you must return a CompletionStage<Void>";
    }

    @Override
    public final DefinitionException definitionCompletionStageOfVoid(String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionCompletionStageOfVoid$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionReturnVoid$str() {
        return "SRMSG00081: Invalid method annotated with @Incoming: %s. The signature is not supported as the produced result would be ignored. The method must return `void`, found %s.";
    }

    @Override
    public final DefinitionException definitionReturnVoid(String methodAsString, String returnType) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionReturnVoid$str(), methodAsString, returnType));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionProduceMessageStreamAndConsumePayload$str() {
        return "SRMSG00082: Invalid method signature for %s - method returning a Multi<Message<O>>, Publisher<Message<O>> or a PublisherBuilder<Message<O>> cannot consume an individual payload. You must consume a Message<I> instead and handle the acknowledgement.";
    }

    @Override
    public final DefinitionException definitionProduceMessageStreamAndConsumePayload(String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionProduceMessageStreamAndConsumePayload$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionProducePayloadStreamAndConsumeMessage$str() {
        return "SRMSG00083: Invalid method signature for %s - method returning a Multi<O>, Publisher<O> or a PublisherBuilder<O> cannot consume an individual message. You must consume a payload instead or return a Publisher<Message<O>> or a PublisherBuilder<Message<O>>.";
    }

    @Override
    public final DefinitionException definitionProducePayloadStreamAndConsumeMessage(String methodAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionProducePayloadStreamAndConsumeMessage$str(), methodAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionProducePayloadStreamAndConsumeMessageStream$str() {
        return "SRMSG00084: Invalid method signature for %s - method returning a Multi<O>, Publisher<O> or a PublisherBuilder<O> cannot consume a Publisher<Message<I>> or a Multi<Message<I>>. You must consume a Multi<I> or a Publisher<I> instead.";
    }

    @Override
    public final DefinitionException definitionProducePayloadStreamAndConsumeMessageStream(String messageAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionProducePayloadStreamAndConsumeMessageStream$str(), messageAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String definitionProduceMessageStreamAndConsumePayloadStream$str() {
        return "SRMSG00085: Invalid method signature for %s - method returning a Multi<Message<O>>, Publisher<Message<O>> or a PublisherBuilder<Message<O>> cannot consume a Publisher<I> or a Multi<I>. You must consume a Multi<Message<I>> or a Publisher<Message<I>> instead and handle the acknowledgement.";
    }

    @Override
    public final DefinitionException definitionProduceMessageStreamAndConsumePayloadStream(String messageAsString) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.definitionProduceMessageStreamAndConsumePayloadStream$str(), messageAsString));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleBeanDeclaration$str() {
        return "SRMSG00086: Multiple beans expose the connector %s : %s, %s";
    }

    @Override
    public final DeploymentException multipleBeanDeclaration(String connector, String bean1, String bean2) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.multipleBeanDeclaration$str(), connector, bean1, bean2));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingConnectorQualifier$str() {
        return "SRMSG00087: The bean %s implements a connector interface but does not use the @Connector qualifier";
    }

    @Override
    public final DefinitionException missingConnectorQualifier(String clazz) {
        DefinitionException result = new DefinitionException(String.format(this.getLoggingLocale(), this.missingConnectorQualifier$str(), clazz));
        ProviderExceptions_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

