/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStorageConfiguration;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.util.logging.Log;

public class GlobalStorageConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalStorageConfiguration> {
    private final AttributeSet attributes;
    private ConfigurationStorage storage = ConfigurationStorage.VOLATILE;

    GlobalStorageConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.attributes = GlobalStorageConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public GlobalStorageConfigurationBuilder supplier(Supplier<? extends LocalConfigurationStorage> configurationStorageSupplier) {
        this.attributes.attribute(GlobalStorageConfiguration.CONFIGURATION_STORAGE_SUPPLIER).set(configurationStorageSupplier);
        return this;
    }

    public GlobalStorageConfigurationBuilder configurationStorage(ConfigurationStorage configurationStorage) {
        this.storage = configurationStorage;
        return this;
    }

    public void validate() {
        if (this.storage.equals((Object)ConfigurationStorage.CUSTOM) && this.attributes.attribute(GlobalStorageConfiguration.CONFIGURATION_STORAGE_SUPPLIER).isNull()) {
            throw Log.CONFIG.customStorageStrategyNotSet();
        }
    }

    public GlobalStorageConfiguration create() {
        return new GlobalStorageConfiguration(this.attributes.protect(), this.storage);
    }

    public GlobalStorageConfigurationBuilder read(GlobalStorageConfiguration template) {
        this.attributes.read(template.attributes());
        this.storage = template.configurationStorage();
        return this;
    }
}

