/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.Functions;
import io.smallrye.config.ConfigMappingClass;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingObject;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.KeyMap;
import io.smallrye.config.NameIterator;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

final class ConfigMappingProvider
implements Serializable {
    private static final long serialVersionUID = 3977667610888849912L;
    private static final BiConsumer<ConfigMappingContext, NameIterator> DO_NOTHING = Functions.discardingBiConsumer();
    private static final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> IGNORE_EVERYTHING;
    private final Map<String, List<Class<?>>> roots;
    private final KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions;
    private final Map<String, ConfigMappingInterface.Property> properties;
    private final KeyMap<String> defaultValues;
    private final boolean validateUnknown;

    ConfigMappingProvider(Builder builder) {
        this.roots = new HashMap(builder.roots);
        this.matchActions = new KeyMap();
        this.properties = new HashMap<String, ConfigMappingInterface.Property>();
        this.defaultValues = new KeyMap();
        this.validateUnknown = builder.validateUnknown;
        ArrayDeque<String> currentPath = new ArrayDeque<String>();
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            NameIterator rootNi = new NameIterator(entry.getKey());
            while (rootNi.hasNext()) {
                String nextSegment = rootNi.getNextSegment();
                if (!nextSegment.isEmpty()) {
                    currentPath.add(nextSegment);
                }
                rootNi.next();
            }
            List<Class<?>> roots = entry.getValue();
            for (Class<?> root : roots) {
                GetRootAction ef = new GetRootAction(root, entry.getKey());
                ConfigMappingInterface mapping = ConfigMappingLoader.getConfigMappingInterface(root);
                this.processEagerGroup(currentPath, this.matchActions, this.defaultValues, mapping.getNamingStrategy(), mapping, ef);
            }
            currentPath.clear();
        }
        for (String[] ignoredPath : builder.ignored) {
            KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> found;
            int len;
            if (ignoredPath[(len = ignoredPath.length) - 1].equals("**")) {
                found = this.matchActions.findOrAdd(ignoredPath, 0, len - 1);
                found.putRootValue(DO_NOTHING);
                ConfigMappingProvider.ignoreRecursively(found);
                continue;
            }
            found = this.matchActions.findOrAdd(ignoredPath);
            found.putRootValue(DO_NOTHING);
        }
    }

    static void ignoreRecursively(KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> root) {
        if (root.getAny() == null) {
            root.putAny(IGNORE_EVERYTHING);
        } else {
            ConfigMappingProvider.ignoreRecursively(root.getAny());
        }
        for (KeyMap value : root.values()) {
            ConfigMappingProvider.ignoreRecursively(value);
        }
    }

    private void processEagerGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction) {
        Class<?> type = group.getInterfaceType();
        HashSet<String> usedProperties = new HashSet<String>();
        for (int i = 0; i < group.getPropertyCount(); ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            String memberName = property.getMethod().getName();
            ArrayDeque<String> propertyPath = new ArrayDeque<String>(currentPath);
            if (!usedProperties.add(memberName)) continue;
            if (!property.isParentPropertyName()) {
                NameIterator ni = new NameIterator(property.hasPropertyName() ? property.getPropertyName() : ConfigMappingProvider.propertyName(property, group, namingStrategy));
                while (ni.hasNext()) {
                    propertyPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            this.processProperty(propertyPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, property);
        }
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processEagerGroup(currentPath, matchActions, defaultValues, namingStrategy, group.getSuperType(i), getEnclosingFunction);
        }
    }

    private void processProperty(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName, ConfigMappingInterface.Property property) {
        if (property.isOptional()) {
            ConfigMappingInterface.MayBeOptionalProperty nestedProperty = property.asOptional().getNestedProperty();
            this.processOptionalProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, nestedProperty);
        } else if (property.isGroup()) {
            this.processEagerGroup(currentPath, matchActions, defaultValues, namingStrategy, property.asGroup().getGroupType(), new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, property.asGroup(), currentPath));
        } else if (property.isPrimitive()) {
            ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
            if (primitiveProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(primitiveProperty.getDefaultValue());
                }
            }
            this.addAction(currentPath, property, DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, DO_NOTHING);
            }
        } else if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            if (leafProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                }
            }
            this.addAction(currentPath, property, DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, DO_NOTHING);
            }
        } else if (property.isMap()) {
            this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), getEnclosingFunction, namingStrategy, group);
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, collectionProperty.getElement());
        }
    }

    private void processOptionalProperty(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName, ConfigMappingInterface.Property property) {
        if (property.isGroup()) {
            ConfigMappingInterface.GroupProperty nestedGroup = property.asGroup();
            GetOrCreateEnclosingGroupInGroup matchAction = new GetOrCreateEnclosingGroupInGroup(getEnclosingFunction, group, nestedGroup, currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, nestedGroup.getGroupType(), matchAction, new HashSet<String>());
        } else if (property.isLeaf()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            if (leafProperty.hasDefaultValue()) {
                defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                if (ConfigMappingProvider.isCollection(currentPath)) {
                    defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                }
            }
            this.addAction(currentPath, property, DO_NOTHING);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, DO_NOTHING);
            }
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processProperty(currentPath, matchActions, defaultValues, namingStrategy, group, getEnclosingFunction, type, memberName, collectionProperty.getElement());
        }
    }

    private void processLazyGroupInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, BiConsumer<ConfigMappingContext, NameIterator> matchAction, HashSet<String> usedProperties) {
        int pc = group.getPropertyCount();
        int pathLen = currentPath.size();
        for (int i = 0; i < pc; ++i) {
            ConfigMappingInterface.Property property = group.getProperty(i);
            if (!property.isParentPropertyName()) {
                NameIterator ni = new NameIterator(property.hasPropertyName() ? property.getPropertyName() : ConfigMappingProvider.propertyName(property, group, namingStrategy));
                while (ni.hasNext()) {
                    currentPath.add(ni.getNextSegment());
                    ni.next();
                }
            }
            if (matchActions.hasRootValue(currentPath)) {
                while (currentPath.size() > pathLen) {
                    currentPath.removeLast();
                }
                continue;
            }
            if (usedProperties.add(String.join((CharSequence)".", String.join((CharSequence)".", currentPath), property.getMethod().getName()))) {
                boolean optional = property.isOptional();
                this.processLazyPropertyInGroup(currentPath, matchActions, defaultValues, matchAction, usedProperties, namingStrategy, group, optional, property);
            }
            while (currentPath.size() > pathLen) {
                currentPath.removeLast();
            }
        }
        int sc = group.getSuperTypeCount();
        for (int i = 0; i < sc; ++i) {
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, group.getSuperType(i), matchAction, usedProperties);
        }
    }

    private void processLazyPropertyInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, BiConsumer<ConfigMappingContext, NameIterator> matchAction, HashSet<String> usedProperties, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface group, boolean optional, ConfigMappingInterface.Property property) {
        if (optional && property.asOptional().getNestedProperty().isGroup()) {
            ConfigMappingInterface.GroupProperty nestedGroup = property.asOptional().getNestedProperty().asGroup();
            GetOrCreateEnclosingGroupInGroup nestedEnclosingFunction = new GetOrCreateEnclosingGroupInGroup(property.isParentPropertyName() ? new GetNestedEnclosing(matchAction) : new ConsumeOneAndThenFn<ConfigMappingObject>(new GetNestedEnclosing(matchAction)), group, nestedGroup, currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, nestedGroup.getGroupType(), nestedEnclosingFunction, new HashSet<String>());
        } else if (property.isGroup()) {
            ConfigMappingInterface.GroupProperty asGroup = property.asGroup();
            GetOrCreateEnclosingGroupInGroup nestedEnclosingFunction = new GetOrCreateEnclosingGroupInGroup(property.isParentPropertyName() ? new GetNestedEnclosing(matchAction) : new ConsumeOneAndThenFn<ConfigMappingObject>(new GetNestedEnclosing(matchAction)), group, asGroup, currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, asGroup.getGroupType(), nestedEnclosingFunction, usedProperties);
        } else if (property.isLeaf() || property.isPrimitive() || optional && property.asOptional().getNestedProperty().isLeaf()) {
            ConsumeOneAndThen actualAction = property.isParentPropertyName() ? matchAction : new ConsumeOneAndThen(matchAction);
            this.addAction(currentPath, property, actualAction);
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), property, actualAction);
            }
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                if (primitiveProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(primitiveProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(primitiveProperty.getDefaultValue());
                    }
                }
            } else if (property.isLeaf() && optional) {
                ConfigMappingInterface.LeafProperty leafProperty = property.asOptional().getNestedProperty().asLeaf();
                if (leafProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                    }
                }
            } else {
                ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
                if (leafProperty.hasDefaultValue()) {
                    defaultValues.findOrAdd(currentPath).putRootValue(leafProperty.getDefaultValue());
                    if (ConfigMappingProvider.isCollection(currentPath)) {
                        defaultValues.findOrAdd(ConfigMappingProvider.inlineCollectionPath(currentPath)).putRootValue(leafProperty.getDefaultValue());
                    }
                }
            }
        } else if (property.isMap()) {
            GetNestedEnclosing nestedMatchAction = new GetNestedEnclosing(matchAction);
            this.processLazyMapInGroup(currentPath, matchActions, defaultValues, property.asMap(), nestedMatchAction, namingStrategy, group);
        } else if (property.isCollection() || optional && property.asOptional().getNestedProperty().isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = optional ? property.asOptional().getNestedProperty().asCollection() : property.asCollection();
            currentPath.addLast(currentPath.removeLast() + "[*]");
            this.processLazyPropertyInGroup(currentPath, matchActions, defaultValues, matchAction, usedProperties, namingStrategy, group, false, collectionProperty.getElement());
        }
    }

    private void processLazyMapInGroup(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingGroup, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        GetOrCreateEnclosingMapInGroup getEnclosingMap = new GetOrCreateEnclosingMapInGroup(getEnclosingGroup, enclosingGroup, property, currentPath);
        this.processLazyMap(currentPath, matchActions, defaultValues, property, getEnclosingMap, namingStrategy, enclosingGroup);
    }

    private void processLazyMap(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty property, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        ConfigMappingInterface.Property valueProperty = property.getValueProperty();
        Class<Converter<?>> keyConvertWith = property.hasKeyConvertWith() ? property.getKeyConvertWith() : null;
        Class<?> keyRawType = property.getKeyRawType();
        currentPath.addLast("*");
        this.processLazyMapValue(currentPath, matchActions, defaultValues, property, valueProperty, keyConvertWith, keyRawType, getEnclosingMap, namingStrategy, enclosingGroup);
    }

    private void processLazyMapValue(ArrayDeque<String> currentPath, KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> matchActions, KeyMap<String> defaultValues, ConfigMappingInterface.MapProperty mapProperty, ConfigMappingInterface.Property property, Class<? extends Converter<?>> keyConvertWith, Class<?> keyRawType, BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.NamingStrategy namingStrategy, ConfigMappingInterface enclosingGroup) {
        if (property.isLeaf()) {
            if (matchActions.hasRootValue(currentPath)) {
                currentPath.removeLast();
                return;
            }
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            Class<? extends Converter<?>> valConvertWith = leafProperty.getConvertWith();
            Class<?> valueRawType = leafProperty.getValueRawType();
            this.addAction(currentPath, mapProperty, (mc, ni) -> {
                String configKey;
                String rawMapKey;
                boolean indexed;
                StringBuilder sb = mc.getStringBuilder();
                boolean restore = false;
                if (ni.getPosition() != -1) {
                    restore = true;
                    ni.previous();
                    sb.setLength(0);
                    sb.append(ni.getAllPreviousSegments());
                }
                Map map = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, (NameIterator)ni);
                if (restore) {
                    ni.next();
                    sb.setLength(0);
                    sb.append(ni.getAllPreviousSegments());
                }
                if ((indexed = ConfigMappingProvider.isIndexed(ni.getPreviousSegment())) && ni.hasPrevious()) {
                    rawMapKey = ConfigMappingProvider.normalizeIfIndexed(ni.getPreviousSegment());
                    ni.previous();
                    configKey = ni.getAllPreviousSegmentsWith(rawMapKey);
                    ni.next();
                } else {
                    rawMapKey = ni.getPreviousSegment();
                    configKey = ni.getAllPreviousSegments();
                }
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Converter valueConv = valConvertWith != null ? mc.getConverterInstance(valConvertWith) : config.requireConverter(valueRawType);
                if (indexed) {
                    ConfigMappingInterface.CollectionProperty collectionProperty = mapProperty.getValueProperty().asCollection();
                    Class<?> collectionRawType = collectionProperty.getCollectionRawType();
                    IntFunction<Collection<?>> collectionFactory = ConfigMappingContext.createCollectionFactory(collectionRawType);
                    map.put(keyConv.convert(rawMapKey), config.getValues(configKey, valueConv, collectionFactory));
                } else {
                    map.put(keyConv.convert(rawMapKey), config.getValue(configKey, valueConv));
                }
            });
            if (ConfigMappingProvider.isCollection(currentPath)) {
                this.addAction(ConfigMappingProvider.inlineCollectionPath(currentPath), leafProperty, DO_NOTHING);
            }
        } else if (property.isMap()) {
            this.processLazyMap(currentPath, matchActions, defaultValues, property.asMap(), (mc, ni) -> {
                ni.previous();
                Map enclosingMap = (Map)getEnclosingMap.apply((ConfigMappingContext)mc, (NameIterator)ni);
                ni.next();
                String rawMapKey = ni.getPreviousSegment();
                SmallRyeConfig config = mc.getConfig();
                Converter keyConv = keyConvertWith != null ? mc.getConverterInstance(keyConvertWith) : config.requireConverter(keyRawType);
                Object key = keyConv.convert(rawMapKey);
                return (Map)enclosingMap.computeIfAbsent(key, x -> new HashMap());
            }, namingStrategy, enclosingGroup);
        } else if (property.isGroup()) {
            GetOrCreateEnclosingGroupInMap ef = new GetOrCreateEnclosingGroupInMap(getEnclosingMap, mapProperty, enclosingGroup, property.asGroup(), currentPath);
            this.processLazyGroupInGroup(currentPath, matchActions, defaultValues, namingStrategy, property.asGroup().getGroupType(), ef, new HashSet<String>());
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            ConfigMappingInterface.Property element = collectionProperty.getElement();
            if (!element.hasConvertWith()) {
                currentPath.addLast(currentPath.removeLast() + "[*]");
            }
            this.processLazyMapValue(currentPath, matchActions, defaultValues, mapProperty, element, keyConvertWith, keyRawType, getEnclosingMap, namingStrategy, enclosingGroup);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void addAction(ArrayDeque<String> currentPath, ConfigMappingInterface.Property property, BiConsumer<ConfigMappingContext, NameIterator> action) {
        this.matchActions.findOrAdd(currentPath).putRootValue(action);
        this.properties.put(String.join((CharSequence)".", currentPath), property);
    }

    private static boolean isCollection(ArrayDeque<String> currentPath) {
        return currentPath.getLast().endsWith("[*]");
    }

    private static ArrayDeque<String> inlineCollectionPath(ArrayDeque<String> currentPath) {
        ArrayDeque<String> inlineCollectionPath = new ArrayDeque<String>(currentPath);
        String last = inlineCollectionPath.removeLast();
        inlineCollectionPath.addLast(last.substring(0, last.length() - 3));
        return inlineCollectionPath;
    }

    private static String indexName(String name, String groupPath, NameIterator nameIterator) {
        int i;
        String group = new NameIterator(groupPath, true).getPreviousSegment();
        String property = nameIterator.getAllPreviousSegments();
        int start = property.lastIndexOf(ConfigMappingProvider.normalizeIfIndexed(group));
        if (start != -1 && (i = start + ConfigMappingProvider.normalizeIfIndexed(group).length()) < property.length() && property.charAt(i) == '[') {
            while (true) {
                if (property.charAt(i) == ']') {
                    try {
                        int index = Integer.parseInt(property.substring(start + ConfigMappingProvider.normalizeIfIndexed(group).length() + 1, i));
                        return name + "[" + index + "]";
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                if (i >= property.length() - 1) break;
                ++i;
            }
        }
        return name;
    }

    private static String propertyName(ConfigMappingInterface.Property property, ConfigMappingInterface group, ConfigMappingInterface.NamingStrategy namingStrategy) {
        return (String)ConfigMappingProvider.namingStrategy(namingStrategy, group.getNamingStrategy()).apply(property.getPropertyName());
    }

    private static ConfigMappingInterface.NamingStrategy namingStrategy(ConfigMappingInterface.NamingStrategy parent, ConfigMappingInterface.NamingStrategy current) {
        if (!current.isDefault()) {
            return current;
        }
        return parent;
    }

    public static Builder builder() {
        return new Builder();
    }

    KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> getMatchActions() {
        return this.matchActions;
    }

    Map<String, ConfigMappingInterface.Property> getProperties() {
        return this.properties;
    }

    KeyMap<String> getDefaultValues() {
        return this.defaultValues;
    }

    ConfigMappingContext mapConfiguration(SmallRyeConfig config) throws ConfigValidationException {
        for (ConfigSource configSource : config.getConfigSources()) {
            if (!(configSource instanceof DefaultValuesConfigSource)) continue;
            DefaultValuesConfigSource defaultValuesConfigSource = (DefaultValuesConfigSource)configSource;
            defaultValuesConfigSource.registerDefaults(this.defaultValues);
        }
        config.addPropertyNames(ConfigMappingProvider.additionalMappedProperties(new HashSet<String>(this.getProperties().keySet()), config));
        return SecretKeys.doUnlocked(() -> this.mapConfigurationInternal(config));
    }

    private ConfigMappingContext mapConfigurationInternal(SmallRyeConfig config) throws ConfigValidationException {
        Assert.checkNotNullParam((String)"config", (Object)config);
        ConfigMappingContext context = new ConfigMappingContext(config);
        if (this.roots.isEmpty()) {
            return context;
        }
        for (Map.Entry<String, List<Class<?>>> entry : this.roots.entrySet()) {
            String path = entry.getKey();
            List<Class<?>> roots = entry.getValue();
            for (Class<?> root : roots) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), path);
                ConfigMappingObject group = (ConfigMappingObject)context.constructRoot(root);
                context.registerRoot(root, path, group);
            }
        }
        for (String name : config.getPropertyNames()) {
            NameIterator ni = new NameIterator(name);
            if (!this.isPropertyInRoot(ni)) continue;
            BiConsumer<ConfigMappingContext, NameIterator> action = this.matchActions.findRootValue(ni);
            if (action != null) {
                action.accept(context, ni);
                continue;
            }
            context.unknownProperty(name);
        }
        context.validateUnknown(config.getOptionalValue("smallrye.config.mapping.validate-unknown", Boolean.TYPE).orElse(this.validateUnknown));
        List<ConfigValidationException.Problem> problems = context.getProblems();
        if (!problems.isEmpty()) {
            throw new ConfigValidationException(problems.toArray(ConfigValidationException.Problem.NO_PROBLEMS));
        }
        context.fillInOptionals();
        return context;
    }

    private boolean isPropertyInRoot(NameIterator propertyName) {
        Set<String> registeredRoots = this.roots.keySet();
        block0: for (String registeredRoot : registeredRoots) {
            if (registeredRoot.length() == 0) {
                return true;
            }
            if (propertyName.getName().length() <= registeredRoot.length()) continue;
            NameIterator root = new NameIterator(registeredRoot);
            while (root.hasNext()) {
                String segment = root.getNextSegment();
                if (!propertyName.hasNext()) {
                    propertyName.goToStart();
                    continue block0;
                }
                String nextSegment = propertyName.getNextSegment();
                if (!segment.equals(ConfigMappingProvider.normalizeIfIndexed(nextSegment))) {
                    propertyName.goToStart();
                    continue block0;
                }
                root.next();
                propertyName.next();
                if (root.hasNext() || !propertyName.hasNext()) continue;
                propertyName.goToStart();
                return true;
            }
        }
        return false;
    }

    private static Set<String> additionalMappedProperties(Set<String> mappedProperties, SmallRyeConfig config) {
        HashSet envProperties = new HashSet();
        for (ConfigSource source : config.getConfigSources(EnvConfigSource.class)) {
            envProperties.addAll(source.getPropertyNames());
        }
        for (String propertyName : config.getPropertyNames()) {
            mappedProperties.remove(propertyName);
        }
        HashSet<String> additionalMappedProperties = new HashSet<String>();
        for (String mappedProperty : mappedProperties) {
            HashSet<String> matchedEnvProperties = new HashSet<String>();
            String endMappedProperty = StringUtil.replaceNonAlphanumericByUnderscores((String)mappedProperty);
            for (String envProperty : envProperties) {
                if (envProperty.equalsIgnoreCase(endMappedProperty)) {
                    additionalMappedProperties.add(mappedProperty);
                    matchedEnvProperties.add(envProperty);
                    break;
                }
                NameIterator ni = new NameIterator(mappedProperty);
                StringBuilder sb = new StringBuilder();
                while (ni.hasNext()) {
                    String propertySegment = ni.getNextSegment();
                    if (ConfigMappingProvider.isIndexed(propertySegment)) {
                        int position = ni.getPosition();
                        int indexStart = propertySegment.indexOf("[") + position + 1;
                        if (envProperty.length() >= indexStart && envProperty.toLowerCase().startsWith(StringUtil.replaceNonAlphanumericByUnderscores((String)(sb + propertySegment.substring(0, indexStart - position - 1) + "_")))) {
                            int indexEnd = -1;
                            for (int i = indexStart + 1; i < envProperty.length(); ++i) {
                                if (envProperty.charAt(i) != '_') continue;
                                indexEnd = i;
                                break;
                            }
                            String index = envProperty.substring(indexStart + 1, indexEnd);
                            sb.append(propertySegment, 0, propertySegment.indexOf("[") + 1).append(index).append("]");
                        }
                    } else {
                        sb.append(propertySegment);
                    }
                    ni.next();
                    if (!ni.hasNext()) continue;
                    sb.append(".");
                }
                String mappedPropertyToMatch = sb.toString();
                if (!envProperty.equalsIgnoreCase(StringUtil.replaceNonAlphanumericByUnderscores((String)mappedPropertyToMatch))) continue;
                additionalMappedProperties.add(mappedPropertyToMatch);
                matchedEnvProperties.add(envProperty);
            }
            envProperties.removeAll(matchedEnvProperties);
        }
        return additionalMappedProperties;
    }

    private static String normalizeIfIndexed(String propertyName) {
        int indexStart = propertyName.indexOf("[");
        int indexEnd = propertyName.indexOf("]");
        if (indexStart != -1 && indexEnd != -1) {
            String index = propertyName.substring(indexStart + 1, indexEnd);
            if (index.equals("*")) {
                return propertyName.substring(0, indexStart);
            }
            try {
                Integer.parseInt(index);
                return propertyName.substring(0, indexStart);
            }
            catch (NumberFormatException e) {
                return propertyName;
            }
        }
        return propertyName;
    }

    private static boolean isIndexed(String propertyName) {
        int indexStart = propertyName.indexOf("[");
        int indexEnd = propertyName.indexOf("]");
        if (indexStart != -1 && indexEnd != -1) {
            String index = propertyName.substring(indexStart + 1, indexEnd);
            if (index.equals("*")) {
                return true;
            }
            try {
                Integer.parseInt(index);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    static {
        KeyMap<BiConsumer<ConfigMappingContext, NameIterator>> map = new KeyMap<BiConsumer<ConfigMappingContext, NameIterator>>();
        map.putRootValue(DO_NOTHING);
        map.putAny(map);
        IGNORE_EVERYTHING = map;
    }

    public static final class Builder {
        final Set<Class<?>> types = new HashSet();
        final Map<String, List<Class<?>>> roots = new HashMap();
        final List<String[]> ignored = new ArrayList<String[]>();
        boolean validateUnknown = true;

        Builder() {
        }

        public Builder addRoot(String path, Class<?> type) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            Assert.checkNotNullParam((String)"type", type);
            this.types.add(type);
            this.roots.computeIfAbsent(path, k -> new ArrayList(4)).add(ConfigMappingLoader.getConfigMappingClass(type));
            return this;
        }

        public Builder addIgnored(String path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.ignored.add(path.split("\\."));
            return this;
        }

        public Builder validateUnknown(boolean validateUnknown) {
            this.validateUnknown = validateUnknown;
            return this;
        }

        public ConfigMappingProvider build() {
            boolean allConfigurationProperties = true;
            for (Class<?> type : this.types) {
                if (ConfigMappingClass.getConfigurationClass(type) != null) continue;
                allConfigurationProperties = false;
                break;
            }
            if (allConfigurationProperties) {
                this.validateUnknown = false;
            }
            return new ConfigMappingProvider(this);
        }
    }

    static class GetNestedEnclosing
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final BiConsumer<ConfigMappingContext, NameIterator> matchAction;

        public GetNestedEnclosing(BiConsumer<ConfigMappingContext, NameIterator> matchAction) {
            this.matchAction = matchAction;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext configMappingContext, NameIterator nameIterator) {
            if (this.matchAction instanceof BiFunction) {
                return (ConfigMappingObject)((BiFunction)((Object)this.matchAction)).apply(configMappingContext, nameIterator);
            }
            return null;
        }
    }

    static class GetFieldOfEnclosing
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction;
        private final Class<?> type;
        private final String memberName;

        GetFieldOfEnclosing(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> getEnclosingFunction, Class<?> type, String memberName) {
            this.getEnclosingFunction = getEnclosingFunction;
            this.type = type;
            this.memberName = memberName;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            ConfigMappingObject outer = this.getEnclosingFunction.apply(context, ni);
            return (ConfigMappingObject)context.getEnclosedField(this.type, this.memberName, outer);
        }
    }

    static class GetOrCreateEnclosingMapInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.MapProperty enclosedGroup;
        private final String groupPath;

        GetOrCreateEnclosingMapInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.MapProperty enclosedGroup, ArrayDeque<String> path) {
            this.delegate = delegate;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
            this.groupPath = String.join((CharSequence)".", path);
        }

        @Override
        public Map<?, ?> apply(ConfigMappingContext context, NameIterator ni) {
            boolean consumeName;
            boolean bl = consumeName = !this.enclosedGroup.isParentPropertyName();
            if (consumeName) {
                ni.previous();
            }
            ConfigMappingObject ourEnclosing = this.delegate.apply(context, ni);
            if (consumeName) {
                ni.next();
            }
            Class<?> enclosingType = this.enclosingGroup.getInterfaceType();
            String key = ConfigMappingProvider.indexName(this.enclosedGroup.getMethod().getName(), this.groupPath, ni);
            HashMap val = (HashMap)context.getEnclosedField(enclosingType, key, ourEnclosing);
            context.applyNamingStrategy(this.enclosingGroup.getNamingStrategy());
            if (val == null) {
                val = new HashMap();
                context.registerEnclosedField(enclosingType, key, ourEnclosing, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }
    }

    static class GetOrCreateEnclosingGroupInMap
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap;
        private final ConfigMappingInterface.MapProperty enclosingMap;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;
        private final String mapPath;

        GetOrCreateEnclosingGroupInMap(BiFunction<ConfigMappingContext, NameIterator, Map<?, ?>> getEnclosingMap, ConfigMappingInterface.MapProperty enclosingMap, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup, ArrayDeque<String> path) {
            this.getEnclosingMap = getEnclosingMap;
            this.enclosingMap = enclosingMap;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
            this.mapPath = String.join((CharSequence)".", path);
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            NameIterator mapPath = this.toMapPath(ni);
            Map<?, ?> ourEnclosing = this.getEnclosingMap.apply(context, mapPath);
            Converter keyConverter = context.getKeyConverter(this.enclosingGroup.getInterfaceType(), this.enclosingMap.getMethod().getName(), this.enclosingMap.getLevels() - 1);
            MapKey mapKey = this.enclosingMap.getValueProperty().isCollection() ? MapKey.collectionKey(mapPath.getNextSegment(), keyConverter) : MapKey.key(mapPath.getNextSegment(), ni.getAllPreviousSegments(), keyConverter);
            ConfigMappingObject val = (ConfigMappingObject)context.getEnclosedField(this.enclosingGroup.getInterfaceType(), mapKey.getKey(), ourEnclosing);
            if (val == null) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), mapPath.getAllPreviousSegmentsWith(mapKey.getKey()));
                context.applyNamingStrategy(ConfigMappingProvider.namingStrategy(this.enclosedGroup.getGroupType().getNamingStrategy(), this.enclosingGroup.getNamingStrategy()));
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                context.registerEnclosedField(this.enclosingGroup.getInterfaceType(), mapKey.getKey(), ourEnclosing, val);
                if (this.enclosingMap.getValueProperty().isCollection()) {
                    ConfigMappingInterface.CollectionProperty collectionProperty = this.enclosingMap.getValueProperty().asCollection();
                    Collection<?> collection = (Collection<?>)ourEnclosing.get(mapKey.getConvertedKey());
                    if (collection == null) {
                        List<Integer> indexes;
                        Class<?> collectionRawType = collectionProperty.getCollectionRawType();
                        IntFunction<Collection<?>> collectionFactory = ConfigMappingContext.createCollectionFactory(collectionRawType);
                        collection = collectionFactory.apply((indexes = context.getConfig().getIndexedPropertiesIndexes(mapPath.getAllPreviousSegmentsWith(ConfigMappingProvider.normalizeIfIndexed(mapKey.getKey())))).size());
                        if (collection instanceof List) {
                            for (Integer index : indexes) {
                                ((List)collection).add(index, null);
                            }
                        }
                        ourEnclosing.put(mapKey.getConvertedKey(), collection);
                    }
                    if (collection instanceof List) {
                        ((List)collection).set(mapKey.getIndex(), val);
                    } else {
                        collection.add(val);
                    }
                } else {
                    ourEnclosing.put(mapKey.getConvertedKey(), val);
                }
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator ni) {
            this.apply(context, ni);
        }

        private NameIterator toMapPath(NameIterator ni) {
            int segments = 0;
            NameIterator countSegments = new NameIterator(this.mapPath);
            while (countSegments.hasNext()) {
                ++segments;
                countSegments.next();
            }
            --segments;
            NameIterator mapPath = new NameIterator(ni.getName());
            for (int i = 0; i < segments; ++i) {
                mapPath.next();
            }
            return mapPath;
        }

        static class MapKey {
            private final String key;
            private final Object convertedKey;

            public MapKey(String key, Object convertedKey) {
                this.key = key;
                this.convertedKey = convertedKey;
            }

            public String getKey() {
                return this.key;
            }

            public Object getConvertedKey() {
                return this.convertedKey;
            }

            public int getIndex() {
                int indexStart = this.key.indexOf("[");
                int indexEnd = this.key.indexOf("]");
                if (indexStart != -1 && indexEnd != -1) {
                    String index = this.key.substring(indexStart + 1, indexEnd);
                    try {
                        return Integer.parseInt(index);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                }
                throw new IllegalArgumentException();
            }

            static MapKey key(String mapKey, String mapPath, Converter<?> keyConverter) {
                Object convertedKey;
                Object key = mapKey;
                if (mapPath.charAt(mapPath.length() - 1) == '\"' && mapPath.charAt(mapPath.length() - 1 - mapKey.length() - 1) == '\"') {
                    key = "\"" + mapKey + "\"";
                }
                if ((convertedKey = keyConverter.convert(mapKey)).equals(mapKey)) {
                    convertedKey = ConfigMappingProvider.normalizeIfIndexed(mapKey);
                }
                return new MapKey(ConfigMappingProvider.normalizeIfIndexed((String)key), convertedKey);
            }

            static MapKey collectionKey(String mapKey, Converter<?> keyConverter) {
                Object convertedKey = keyConverter.convert(mapKey);
                if (convertedKey.equals(mapKey)) {
                    convertedKey = ConfigMappingProvider.normalizeIfIndexed(mapKey);
                }
                return new MapKey(mapKey, convertedKey);
            }
        }
    }

    static class GetOrCreateEnclosingGroupInGroup
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject>,
    BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate;
        private final ConfigMappingInterface enclosingGroup;
        private final ConfigMappingInterface.GroupProperty enclosedGroup;
        private final String groupPath;

        GetOrCreateEnclosingGroupInGroup(BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> delegate, ConfigMappingInterface enclosingGroup, ConfigMappingInterface.GroupProperty enclosedGroup, ArrayDeque<String> path) {
            this.delegate = delegate;
            this.enclosingGroup = enclosingGroup;
            this.enclosedGroup = enclosedGroup;
            this.groupPath = String.join((CharSequence)".", path);
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext context, NameIterator ni) {
            ConfigMappingObject ourEnclosing = this.delegate.apply(context, ni);
            Class<?> enclosingType = this.enclosingGroup.getInterfaceType();
            String key = ConfigMappingProvider.indexName(this.enclosedGroup.getMethod().getName(), this.groupPath, ni);
            ConfigMappingObject val = (ConfigMappingObject)context.getEnclosedField(enclosingType, key, ourEnclosing);
            context.applyNamingStrategy(ConfigMappingProvider.namingStrategy(this.enclosedGroup.getGroupType().getNamingStrategy(), this.enclosingGroup.getNamingStrategy()));
            if (val == null) {
                StringBuilder sb = context.getStringBuilder();
                sb.replace(0, sb.length(), ni.getAllPreviousSegments());
                val = (ConfigMappingObject)context.constructGroup(this.enclosedGroup.getGroupType().getInterfaceType());
                context.registerEnclosedField(enclosingType, key, ourEnclosing, val);
            }
            return val;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            this.apply(context, nameIterator);
        }
    }

    static class GetRootAction
    implements BiFunction<ConfigMappingContext, NameIterator, ConfigMappingObject> {
        private final Class<?> root;
        private final String rootPath;

        GetRootAction(Class<?> root, String rootPath) {
            this.root = root;
            this.rootPath = rootPath;
        }

        @Override
        public ConfigMappingObject apply(ConfigMappingContext mc, NameIterator ni) {
            return mc.getRoot(this.root, this.rootPath);
        }
    }

    static final class ConsumeOneAndThenFn<T>
    implements BiFunction<ConfigMappingContext, NameIterator, T> {
        private final BiFunction<ConfigMappingContext, NameIterator, T> delegate;

        ConsumeOneAndThenFn(BiFunction<ConfigMappingContext, NameIterator, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T apply(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            T result = this.delegate.apply(context, nameIterator);
            nameIterator.next();
            return result;
        }
    }

    static final class ConsumeOneAndThen
    implements BiConsumer<ConfigMappingContext, NameIterator> {
        private final BiConsumer<ConfigMappingContext, NameIterator> delegate;

        ConsumeOneAndThen(BiConsumer<ConfigMappingContext, NameIterator> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(ConfigMappingContext context, NameIterator nameIterator) {
            nameIterator.previous();
            this.delegate.accept(context, nameIterator);
            nameIterator.next();
        }
    }
}

