/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import jakarta.ejb.EJBException;
import jakarta.ejb.TransactionManagementType;
import jakarta.transaction.Synchronization;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBean;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatefulSessionSynchronizationInterceptor
extends AbstractEJBInterceptor {
    private final boolean containerManagedTransactions;
    private static final Factory CONTAINER_MANAGED = new Factory(TransactionManagementType.CONTAINER);
    private static final Factory BEAN_MANAGED = new Factory(TransactionManagementType.BEAN);

    public static InterceptorFactory factory(TransactionManagementType type) {
        return type == TransactionManagementType.CONTAINER ? CONTAINER_MANAGED : BEAN_MANAGED;
    }

    public StatefulSessionSynchronizationInterceptor(boolean containerManagedTransactions) {
        this.containerManagedTransactions = containerManagedTransactions;
    }

    /*
     * Exception decompiling
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object getLockOwner(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Object owner = transactionSynchronizationRegistry.getTransactionKey();
        return owner != null ? owner : Thread.currentThread();
    }

    static void close(StatefulSessionBean<SessionID, StatefulSessionComponentInstance> bean) {
        StatefulSessionComponentInstance instance = bean.getInstance();
        try {
            bean.close();
        }
        finally {
            StatefulSessionSynchronizationInterceptor.releaseLock(instance);
        }
    }

    static void releaseLock(StatefulSessionComponentInstance instance) {
        instance.getLock().unlock(StatefulSessionSynchronizationInterceptor.getLockOwner(instance.getComponent().getTransactionSynchronizationRegistry()));
        EjbLogger.ROOT_LOGGER.tracef("Released lock: %s", instance.getLock());
    }

    static void handleAfterCompletion(boolean committed, StatefulSessionBean<SessionID, StatefulSessionComponentInstance> bean) {
        StatefulSessionComponentInstance instance = bean.getInstance();
        try {
            EjbLogger.ROOT_LOGGER.tracef("After completion callback invoked on Transaction synchronization: %s", instance);
            if (!bean.isDiscarded()) {
                instance.afterCompletion(committed);
            }
        }
        catch (Throwable t) {
            StatefulSessionSynchronizationInterceptor.handleThrowable(t, bean);
        }
        if (bean.isRemoved()) {
            try {
                instance.destroy();
            }
            catch (Throwable t) {
                StatefulSessionSynchronizationInterceptor.handleThrowable(t, bean);
            }
        }
        instance.getComponent().getTransactionSynchronizationRegistry().putResource((Object)bean.getId(), null);
        StatefulSessionSynchronizationInterceptor.close(bean);
    }

    private static void handleThrowable(Throwable t, StatefulSessionBean<SessionID, StatefulSessionComponentInstance> bean) {
        StatefulSessionComponentInstance instance = bean.getInstance();
        EjbLogger.ROOT_LOGGER.discardingStatefulComponent(instance, t);
        try {
            bean.discard();
        }
        finally {
            StatefulSessionSynchronizationInterceptor.releaseLock(instance);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw (EJBException)new EJBException().initCause(t);
    }

    private static final class StatefulSessionSynchronization
    implements Synchronization {
        private final StatefulSessionBean<SessionID, StatefulSessionComponentInstance> bean;

        StatefulSessionSynchronization(StatefulSessionBean<SessionID, StatefulSessionComponentInstance> bean) {
            this.bean = bean;
        }

        public void beforeCompletion() {
            StatefulSessionComponentInstance instance = this.bean.getInstance();
            try {
                EjbLogger.ROOT_LOGGER.tracef("Before completion callback invoked on Transaction synchronization: %s of stateful component instance: %s", this, instance);
                if (!this.bean.isDiscarded()) {
                    instance.beforeCompletion();
                }
            }
            catch (Throwable t) {
                StatefulSessionSynchronizationInterceptor.handleThrowable(t, this.bean);
            }
        }

        public void afterCompletion(int status) {
            int s;
            boolean committed;
            StatefulSessionComponentInstance instance = this.bean.getInstance();
            AtomicInteger state = instance.getInvocationSyncState();
            boolean bl = committed = status == 3;
            do {
                if ((s = state.get()) != 0) continue;
                StatefulSessionSynchronizationInterceptor.handleAfterCompletion(committed, this.bean);
                break;
            } while (s != 1 || !state.compareAndSet(1, committed ? 3 : 2));
        }
    }

    private static class Factory
    extends ComponentInstanceInterceptorFactory {
        private final TransactionManagementType type;

        public Factory(TransactionManagementType type) {
            this.type = type;
        }

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new StatefulSessionSynchronizationInterceptor(this.type == TransactionManagementType.CONTAINER);
        }
    }
}

