/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationClientStartService
implements Service<ApplicationClientStartService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"appClientStart"});
    private final InjectedValue<ApplicationClientDeploymentService> applicationClientDeploymentServiceInjectedValue = new InjectedValue();
    private final InjectedValue<Component> applicationClientComponent = new InjectedValue();
    private final InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue;
    private final List<SetupAction> setupActions;
    private final Method mainMethod;
    private final String[] parameters;
    private final ClassLoader classLoader;
    private Thread thread;
    private ComponentInstance instance;

    public ApplicationClientStartService(Method mainMethod, String[] parameters, InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue, ClassLoader classLoader, List<SetupAction> setupActions) {
        this.mainMethod = mainMethod;
        this.parameters = parameters;
        this.namespaceContextSelectorInjectedValue = namespaceContextSelectorInjectedValue;
        this.classLoader = classLoader;
        this.setupActions = setupActions;
    }

    public synchronized void start(StartContext context) throws StartException {
        final ServiceContainer serviceContainer = context.getController().getServiceContainer();
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    Throwable originalException = null;
                    try {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)ApplicationClientStartService.this.classLoader);
                        ((ApplicationClientDeploymentService)ApplicationClientStartService.this.applicationClientDeploymentServiceInjectedValue.getValue()).getDeploymentCompleteLatch().await();
                        NamespaceContextSelector.setDefault((NamespaceContextSelector)ApplicationClientStartService.this.namespaceContextSelectorInjectedValue);
                        try {
                            for (SetupAction action : ApplicationClientStartService.this.setupActions) {
                                action.setup(Collections.emptyMap());
                            }
                            ApplicationClientStartService.this.instance = ((Component)ApplicationClientStartService.this.applicationClientComponent.getValue()).createInstance();
                            ApplicationClientStartService.this.mainMethod.invoke(null, new Object[]{ApplicationClientStartService.this.parameters});
                        }
                        catch (Throwable ex) {
                            if (ex instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            originalException = ex;
                        }
                        finally {
                            ListIterator<SetupAction> iterator = ApplicationClientStartService.this.setupActions.listIterator(ApplicationClientStartService.this.setupActions.size());
                            Throwable suppressed = originalException;
                            while (iterator.hasPrevious()) {
                                SetupAction action = iterator.previous();
                                try {
                                    action.teardown(Collections.emptyMap());
                                }
                                catch (Throwable e) {
                                    if (suppressed != null) {
                                        suppressed.addSuppressed(e);
                                        continue;
                                    }
                                    suppressed = e;
                                }
                            }
                            if (suppressed != null) {
                                if (suppressed instanceof RuntimeException) {
                                    throw (RuntimeException)suppressed;
                                }
                                if (suppressed instanceof Error) {
                                    throw (Error)suppressed;
                                }
                                throw new RuntimeException(suppressed);
                            }
                        }
                    }
                    catch (Exception e) {
                        AppClientLogger.ROOT_LOGGER.exceptionRunningAppClient(e, e.getClass().getSimpleName());
                    }
                    finally {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                    }
                }
                finally {
                    serviceContainer.shutdown();
                }
            }
        });
        this.thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (serviceContainer != null) {
                    serviceContainer.shutdown();
                }
            }
        }));
    }

    public synchronized void stop(StopContext context) {
        if (this.instance != null) {
            this.instance.destroy();
        }
        this.thread.interrupt();
        this.thread = null;
    }

    public ApplicationClientStartService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ApplicationClientDeploymentService> getApplicationClientDeploymentServiceInjectedValue() {
        return this.applicationClientDeploymentServiceInjectedValue;
    }

    public InjectedValue<Component> getApplicationClientComponent() {
        return this.applicationClientComponent;
    }
}

