/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.rest;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.util.Collections;
import java.util.List;

@Provider
public class OpenTelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private Instrumenter<ClientRequestContext, ClientResponseContext> instrumenter;

    public OpenTelemetryClientFilter() {
    }

    @Inject
    public OpenTelemetryClientFilter(OpenTelemetry openTelemetry) {
        ClientAttributesExtractor clientAttributesExtractor = new ClientAttributesExtractor();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)clientAttributesExtractor));
        builder.setInstrumentationVersion(OpenTelemetryConfig.INSTRUMENTATION_VERSION);
        this.instrumenter = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)clientAttributesExtractor)).addAttributesExtractor((AttributesExtractor)HttpClientAttributesExtractor.create((HttpClientAttributesGetter)clientAttributesExtractor)).buildClientInstrumenter((TextMapSetter)new ClientRequestContextTextMapSetter());
    }

    public void filter(ClientRequestContext request) {
        Context parentContext;
        if (this.instrumenter != null && this.instrumenter.shouldStart(parentContext = Context.current(), (Object)request)) {
            Context spanContext = this.instrumenter.start(parentContext, (Object)request);
            Scope scope = spanContext.makeCurrent();
            request.setProperty("otel.span.client.context", (Object)spanContext);
            request.setProperty("otel.span.client.parentContext", (Object)parentContext);
            request.setProperty("otel.span.client.scope", (Object)scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ClientRequestContext request, ClientResponseContext response) {
        if (this.instrumenter != null) {
            Scope scope = (Scope)request.getProperty("otel.span.client.scope");
            if (scope == null) {
                return;
            }
            Context spanContext = (Context)request.getProperty("otel.span.client.context");
            try {
                this.instrumenter.end(spanContext, (Object)request, (Object)response, null);
            }
            finally {
                scope.close();
                request.removeProperty("otel.span.client.context");
                request.removeProperty("otel.span.client.parentContext");
                request.removeProperty("otel.span.client.scope");
            }
        }
    }

    private static class ClientAttributesExtractor
    implements HttpClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        private ClientAttributesExtractor() {
        }

        public String url(ClientRequestContext request) {
            return request.getUri().toString();
        }

        public String flavor(ClientRequestContext request, ClientResponseContext response) {
            return null;
        }

        public String method(ClientRequestContext request) {
            return request.getMethod();
        }

        public List<String> requestHeader(ClientRequestContext request, String name) {
            return (List)request.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public Integer statusCode(ClientRequestContext request, ClientResponseContext response, Throwable throwable) {
            return response.getStatus();
        }

        public List<String> responseHeader(ClientRequestContext request, ClientResponseContext response, String name) {
            return (List)response.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }
    }

    private static class ClientRequestContextTextMapSetter
    implements TextMapSetter<ClientRequestContext> {
        private ClientRequestContextTextMapSetter() {
        }

        public void set(ClientRequestContext carrier, String key, String value) {
            if (carrier != null) {
                carrier.getHeaders().put((Object)key, Collections.singletonList(value));
            }
        }
    }
}

