/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.SoftValueLongObjectHashMap;
import org.jboss.logging.Logger;
import org.junit.Test;

public class SoftValueMapTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(SoftValueMapTest.class);

    @Test
    public void testEvictions() {
        SoftValueMapTest.forceGC();
        long maxMemory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory();
        int bufferSize = (int)(maxMemory / 100L);
        SoftValueLongObjectHashMap softCache = new SoftValueLongObjectHashMap(100);
        int MAX_ELEMENTS = 1000;
        for (long i = 0L; i < 1000L; ++i) {
            softCache.put(i, (SoftValueLongObjectHashMap.ValueCache)new Value(new byte[bufferSize]));
        }
        SoftValueMapTest.assertTrue((softCache.size() < 1000 ? (byte)1 : 0) != 0);
        log.debug((Object)("SoftCache.size " + softCache.size()));
        log.debug((Object)("Soft cache has " + softCache.size() + " elements"));
    }

    @Test
    public void testEvictionsLeastUsed() {
        Value v;
        long i;
        SoftValueMapTest.forceGC();
        SoftValueLongObjectHashMap softCache = new SoftValueLongObjectHashMap(200);
        for (i = 0L; i < 100L; ++i) {
            v = new Value(new byte[1]);
            v.setLive(true);
            softCache.put(i, (SoftValueLongObjectHashMap.ValueCache)v);
        }
        for (i = 100L; i < 200L; ++i) {
            v = new Value(new byte[1]);
            softCache.put(i, (SoftValueLongObjectHashMap.ValueCache)v);
        }
        SoftValueMapTest.assertNotNull((Object)softCache.get(100L));
        softCache.put(300L, (SoftValueLongObjectHashMap.ValueCache)new Value(new byte[1]));
        for (i = 0L; i < 100L; ++i) {
            SoftValueMapTest.assertNotNull((Object)softCache.get(i));
        }
        SoftValueMapTest.assertNotNull((Object)softCache.get(100L));
        SoftValueMapTest.assertNull((Object)softCache.get(101L));
        log.debug((Object)("SoftCache.size " + softCache.size()));
        log.debug((Object)("Soft cache has " + softCache.size() + " elements"));
    }

    @Test
    public void testEvictOldestElement() {
        Value one = new Value(new byte[100]);
        Value two = new Value(new byte[100]);
        Value three = new Value(new byte[100]);
        SoftValueLongObjectHashMap softCache = new SoftValueLongObjectHashMap(2);
        softCache.put(3L, (SoftValueLongObjectHashMap.ValueCache)three);
        softCache.put(2L, (SoftValueLongObjectHashMap.ValueCache)two);
        softCache.put(1L, (SoftValueLongObjectHashMap.ValueCache)one);
        SoftValueMapTest.assertNull((Object)softCache.get(3L));
        SoftValueMapTest.assertEquals((Object)two, (Object)softCache.get(2L));
        SoftValueMapTest.assertEquals((Object)one, (Object)softCache.get(1L));
    }

    class Value
    implements SoftValueLongObjectHashMap.ValueCache {
        byte[] payload;
        boolean live;

        Value(byte[] payload) {
            this.payload = payload;
        }

        public boolean isLive() {
            return this.live;
        }

        public void setLive(boolean live) {
            this.live = live;
        }
    }
}

