/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFilesRepository;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.junit.Assert;
import org.junit.Test;

public class JournalFileRepositoryOrderTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrder() throws Throwable {
        ExecutorService executorService = Executors.newFixedThreadPool(3, (ThreadFactory)new ActiveMQThreadFactory("test", false, JournalFileRepositoryOrderTest.class.getClassLoader()));
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread t = null;
        try {
            FakeSequentialFileFactory fakeSequentialFileFactory = new FakeSequentialFileFactory();
            JournalImpl journal = new JournalImpl((ExecutorFactory)new OrderedExecutorFactory((Executor)executorService), 10240, 2, -1, -1, 0, (SequentialFileFactory)fakeSequentialFileFactory, "file", "file", 1, 0);
            final JournalFilesRepository repository = journal.getFilesRepository();
            final LinkedBlockingDeque<JournalFile> dataFiles = new LinkedBlockingDeque<JournalFile>();
            t = new Thread(){

                @Override
                public void run() {
                    while (running.get()) {
                        try {
                            JournalFile file;
                            Wait.waitFor(() -> !running.get() || dataFiles.size() > 10, (long)1000L, (long)1L);
                            while (running.get() && (file = (JournalFile)dataFiles.poll()) != null) {
                                repository.addFreeFile(file, false);
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            t.start();
            JournalFile file = null;
            LinkedList<Integer> values = new LinkedList<Integer>();
            for (int i = 0; i < 5000; ++i) {
                file = repository.openFile();
                Assert.assertNotNull((Object)file);
                values.add(file.getRecordID());
                dataFiles.push(file);
            }
            int previous = Integer.MIN_VALUE;
            for (Integer v : values) {
                Assert.assertTrue((v > previous ? 1 : 0) != 0);
                previous = v;
            }
        }
        finally {
            running.set(false);
            executorService.shutdownNow();
        }
    }
}

