/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.Assert;
import org.junit.Test;

public class StompWithMessageIDTest
extends StompTestBase {
    @Override
    public boolean isEnableStompMessageId() {
        return true;
    }

    @Test
    public void testEnableMessageID() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithMessageIDTest.getQueuePrefix() + StompWithMessageIDTest.getQueueName());
        frame.setBody("Hello World 1");
        conn.sendFrame(frame);
        frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithMessageIDTest.getQueuePrefix() + StompWithMessageIDTest.getQueueName());
        frame.setBody("Hello World 2");
        conn.sendFrame(frame);
        QueueBrowser browser = this.session.createBrowser(this.queue);
        Enumeration enu = browser.getEnumeration();
        while (enu.hasMoreElements()) {
            Message msg = (Message)enu.nextElement();
            String msgId = msg.getStringProperty("amqMessageId");
            StompWithMessageIDTest.assertNotNull((Object)msgId);
            StompWithMessageIDTest.assertTrue((msgId.indexOf("STOMP") == 0 ? 1 : 0) != 0);
        }
        browser.close();
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        message = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)message);
        message = (TextMessage)consumer.receive(100L);
        Assert.assertNull((Object)message);
        conn.disconnect();
    }
}

