/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StompWebSocketMaxFrameTest
extends StompTestBase {
    private URI wsURI;
    private int wsport = 61614;
    private int stompWSMaxFrameSize = 131072;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v10.stomp"}, {"ws+v11.stomp"}, {"ws+v12.stomp"});
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.server.getRemotingService().createAcceptor("test", "tcp://127.0.0.1:" + this.wsport + "?stompMaxFramePayloadLength=" + this.stompWSMaxFrameSize).start();
        this.wsURI = StompWebSocketMaxFrameTest.createStompClientUri(this.scheme, this.hostname, this.wsport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStompSendReceiveWithMaxFramePayloadLength() throws Exception {
        int size = 65536;
        String largeString1 = RandomStringUtils.randomAlphabetic((int)size);
        String largeString2 = RandomStringUtils.randomAlphabetic((int)size);
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri, false);
        conn.getTransport().setMaxFrameSize(this.stompWSMaxFrameSize);
        conn.getTransport().connect();
        StompClientConnection conn2 = StompClientConnectionFactory.createClientConnection(this.wsURI, false);
        conn2.getTransport().setMaxFrameSize(this.stompWSMaxFrameSize);
        conn2.getTransport().connect();
        Wait.waitFor(() -> conn2.getTransport().isConnected() && conn.getTransport().isConnected(), (long)10000L);
        conn.connect();
        conn2.connect();
        StompWebSocketMaxFrameTest.subscribeQueue(conn2, "sub1", StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName());
        try {
            StompWebSocketMaxFrameTest.send(conn, StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName(), "text/plain", largeString1, false);
            Wait.waitFor(() -> !conn.getTransport().isConnected(), (long)2000L);
            StompWebSocketMaxFrameTest.assertFalse((boolean)conn.getTransport().isConnected());
            StompWebSocketMaxFrameTest.send(conn2, StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName(), "text/plain", largeString2, false);
            Wait.waitFor(() -> !conn2.getTransport().isConnected(), (long)2000L);
            StompWebSocketMaxFrameTest.assertTrue((boolean)conn2.getTransport().isConnected());
            ClientStompFrame frame = conn2.receiveFrame();
            StompWebSocketMaxFrameTest.assertNotNull((Object)frame);
            StompWebSocketMaxFrameTest.assertEquals((Object)largeString2, (Object)frame.getBody());
        }
        finally {
            conn2.closeTransport();
            conn.closeTransport();
        }
    }
}

