/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddressQueueDeleteDelayTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(AddressQueueDeleteDelayTest.class);
    public static final int DURATION_MILLIS = 30000;
    public static final int NEGATIVE_DURATION_MILLIS = 1000;
    public static final int SLEEP_MILLIS = 100;
    private ActiveMQServer server;
    private ClientSession session;
    private ClientSessionFactory sf;
    private ServerLocator locator;

    @Test
    public void testAddressQueueDeleteDelay() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        long deleteQueuesDelay = 150L;
        long deleteAddressesDelay = 500L;
        AddressSettings addressSettings = new AddressSettings().setAutoDeleteQueuesDelay(150L).setAutoDeleteAddressesDelay(500L);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setAutoCreated(Boolean.valueOf(true)));
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue) != null, (long)30000L, (long)100L));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(true);
        producer.send((Message)message);
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        ClientMessage m = consumer.receive(500L);
        AddressQueueDeleteDelayTest.assertNotNull((Object)m);
        m.acknowledge();
        this.session.commit();
        consumer.close();
        long start = System.currentTimeMillis();
        AddressInfo info = this.server.getAddressInfo(address);
        Wait.assertTrue(() -> this.server.locateQueue(queue) == null, (long)30000L, (long)10L);
        Assert.assertNotNull((Object)info);
        Wait.assertTrue(() -> info.getBindingRemovedTimestamp() > 0L, (long)5000L, (long)10L);
        long elapsedTime = System.currentTimeMillis() - start;
        log.debug((Object)("Elapsed time to delete queue: " + elapsedTime));
        AddressQueueDeleteDelayTest.assertTrue((elapsedTime >= 150L ? 1 : 0) != 0);
        start = info.getBindingRemovedTimestamp();
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(address) == null, (long)30000L, (long)100L));
        elapsedTime = System.currentTimeMillis() - start;
        log.debug((Object)("Elapsed time to delete address: " + elapsedTime));
        AddressQueueDeleteDelayTest.assertTrue((String)("ellapsedTime=" + elapsedTime + " while delay is " + 500L), (elapsedTime >= 500L ? 1 : 0) != 0);
    }

    @Test
    public void testAddressQueueDeleteDelayWithAdditionalAddressQueue() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        long deleteQueuesDelay = 300L;
        long deleteAddressesDelay = 500L;
        AddressSettings addressSettings = new AddressSettings().setAutoDeleteQueuesDelay(300L).setAutoDeleteAddressesDelay(500L);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setAutoCreated(Boolean.valueOf(true)));
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue) != null, (long)30000L, (long)100L));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(true);
        producer.send((Message)message);
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        ClientMessage m = consumer.receive(500L);
        AddressQueueDeleteDelayTest.assertNotNull((Object)m);
        m.acknowledge();
        this.session.commit();
        consumer.close();
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(address) != null, (long)30000L, (long)100L));
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue) == null, (long)30000L, (long)100L));
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setAutoCreated(Boolean.valueOf(true)));
        consumer = this.session.createConsumer(queue);
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(address) != null, (long)30000L, (long)100L));
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue) != null, (long)30000L, (long)100L));
        consumer.close();
        long start = System.currentTimeMillis();
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue) == null, (long)30000L, (long)100L));
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(address) == null, (long)30000L, (long)100L));
        AddressQueueDeleteDelayTest.assertTrue((System.currentTimeMillis() - start >= 300L ? 1 : 0) != 0);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setAutoCreated(Boolean.valueOf(true)));
        this.session.deleteQueue(queue);
        start = System.currentTimeMillis();
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(address) == null, (long)30000L, (long)100L));
        AddressQueueDeleteDelayTest.assertTrue((System.currentTimeMillis() - start >= 500L ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultAddressQueueDeleteDelay() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setAutoCreated(Boolean.valueOf(true)));
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue) != null, (long)30000L, (long)100L));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(true);
        producer.send((Message)message);
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        ClientMessage m = consumer.receive(500L);
        AddressQueueDeleteDelayTest.assertNotNull((Object)m);
        m.acknowledge();
        this.session.commit();
        consumer.close();
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue) == null, (long)30000L, (long)100L));
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(address) == null, (long)30000L, (long)100L));
    }

    @Test
    public void testAddressDeleteDelay() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        long deleteAddressesDelay = 500L;
        AddressSettings addressSettings = new AddressSettings().setAutoDeleteAddressesDelay(500L);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createAddress(address, RoutingType.MULTICAST, true);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        this.session.deleteQueue(queue);
        AddressQueueDeleteDelayTest.assertTrue((boolean)Wait.waitFor(() -> this.server.getAddressInfo(address) == null, (long)30000L, (long)100L));
    }

    @Test
    public void testAddressDeleteDelayNegative() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        long deleteAddressesDelay = 500L;
        AddressSettings addressSettings = new AddressSettings().setAutoDeleteAddressesDelay(500L);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createAddress(address, RoutingType.MULTICAST, false);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        this.session.deleteQueue(queue);
        Thread.sleep(1000L);
        Assert.assertTrue((this.server.getAddressInfo(address) != null ? 1 : 0) != 0);
    }

    @Test
    public void testAddressDeleteDelayNegative2() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        long deleteAddressesDelay = 500L;
        AddressSettings addressSettings = new AddressSettings().setAutoDeleteAddressesDelay(500L).setAutoDeleteAddresses(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createAddress(address, RoutingType.MULTICAST, true);
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address));
        this.session.deleteQueue(queue);
        Thread.sleep(1000L);
        Assert.assertTrue((this.server.getAddressInfo(address) != null ? 1 : 0) != 0);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.getConfiguration().setAddressQueueScanPeriod(100L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }
}

