/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.retention;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.Assert;
import org.junit.Test;

public class ReplayTest
extends ActiveMQTestBase {
    ActiveMQServer server;

    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(this.createServer(true, true));
        this.server.getConfiguration().setJournalRetentionDirectory(this.getJournalDir() + "retention");
        this.server.getConfiguration().setJournalFileSize(102400);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo("t1").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration("t1").setAddress("t1").setRoutingType(RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo("t2").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration("t2").setAddress("t2").setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testReplayAMQP() throws Exception {
        this.testReplay("AMQP", 10);
    }

    @Test
    public void testReplayCore() throws Exception {
        this.testReplay("CORE", 10);
    }

    public void testReplay(String protocol, int size) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append(RandomUtil.randomString());
        for (int i = 0; i < size; ++i) {
            buffer.append("*");
        }
        ConnectionFactory cf = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("t1");
            MessageProducer producer = session.createProducer(null);
            producer.send((Destination)queue, (Message)session.createTextMessage(buffer.toString()));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Assert.assertNotNull((Object)consumer.receive(5000L));
            Assert.assertNull((Object)consumer.receiveNoWait());
            this.server.replay(null, null, "t1", "t2", null);
            Queue t2 = session.createQueue("t2");
            MessageConsumer consumert2 = session.createConsumer((Destination)t2);
            TextMessage receivedMessage = (TextMessage)consumert2.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertEquals((Object)buffer.toString(), (Object)receivedMessage.getText());
            Assert.assertNull((Object)consumert2.receiveNoWait());
            this.server.replay(null, null, "t2", "t1", null);
            receivedMessage = (TextMessage)consumer.receive(5000L);
            Assert.assertNotNull((Object)receivedMessage);
            Assert.assertNull((Object)consumer.receiveNoWait());
            this.server.replay(null, null, "t1", "t1", "foo='foo'");
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testReplayLargeAMQP() throws Exception {
        this.testReplay("AMQP", 512000);
    }

    @Test
    public void testReplayLargeCore() throws Exception {
        this.testReplay("CORE", 512000);
    }
}

