/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PageAckScanTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(PageAckScanTest.class);
    private static final String ADDRESS = "MessagesExpiredPagingTest";
    ActiveMQServer server;
    protected static final int PAGE_MAX = 10240;
    protected static final int PAGE_SIZE = 1024;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultConfig(0, true).setJournalSyncNonTransactional(false);
        config.setMessageExpiryScanPeriod(-1L);
        this.server = this.createServer(true, config, 1024, 10240L);
        this.server.getAddressSettingsRepository().clear();
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(10240L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(ADDRESS).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testScanCore() throws Exception {
        this.testScan("CORE", 5000, 1000, 100, 1024);
    }

    @Test
    public void testScanAMQP() throws Exception {
        this.testScan("AMQP", 5000, 1000, 100, 1024);
    }

    public void testScan(String protocol, int numberOfMessages, int numberOfMessageSecondWave, int pagingInterval, int bodySize) throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bodySize; ++i) {
            buffer.append("*");
        }
        String extraBody = buffer.toString();
        Queue queue = this.server.locateQueue(ADDRESS);
        queue.getPagingStore().startPaging();
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue jmsQueue = session.createQueue(ADDRESS);
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (int i = 0; i < 20; ++i) {
                TextMessage message = session.createTextMessage(extraBody);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            session.commit();
        }
        AtomicInteger errors = new AtomicInteger(0);
        ReusableLatch latch = new ReusableLatch(4);
        Runnable done = () -> ((ReusableLatch)latch).countDown();
        Runnable notFound = () -> {
            errors.incrementAndGet();
            done.run();
        };
        AtomicInteger retried = new AtomicInteger(0);
        PageSubscription subscription = queue.getPageSubscription();
        subscription.scanAck(() -> false, (ToIntFunction)new CompareI(15), done, notFound);
        subscription.scanAck(() -> false, (ToIntFunction)new CompareI(11), done, notFound);
        subscription.scanAck(() -> false, (ToIntFunction)new CompareI(99), done, notFound);
        subscription.scanAck(() -> false, (ToIntFunction)new CompareI(-30), done, notFound);
        subscription.scanAck(() -> {
            retried.incrementAndGet();
            return true;
        }, (ToIntFunction)new CompareI(333), done, notFound);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.MINUTES));
        Assert.assertEquals((long)2L, (long)errors.get());
        Wait.assertEquals((int)1, retried::get);
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue jmsQueue = session.createQueue(ADDRESS);
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            for (int i = 0; i < 18; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
                Assert.assertTrue((message.getIntProperty("i") != 11 && message.getIntProperty("i") != 15 ? 1 : 0) != 0);
            }
            Assert.assertNull((Object)consumer.receiveNoWait());
        }
    }

    class CompareI
    implements ToIntFunction<PagedReference> {
        final int i;

        CompareI(int i) {
            this.i = i;
        }

        @Override
        public int applyAsInt(PagedReference ref) {
            return ref.getMessage().getIntProperty("i") - this.i;
        }
    }
}

