/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.ConsumerThread;
import org.junit.Assert;
import org.junit.Test;

public class MessageRedistributionTest
extends ClusterTestBase {
    @Override
    protected boolean isForceUniqueStorageManagerIds() {
        return false;
    }

    @Test
    public void testRemoteConsumerClose() throws Exception {
        this.setupServer(0, true, true);
        this.setupServer(1, true, true);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, true, 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, true, 1, 0);
        this.startServers(0, 1);
        MessageRedistributionTest.waitForTopology((ActiveMQServer)this.servers[0], (int)2);
        MessageRedistributionTest.waitForTopology((ActiveMQServer)this.servers[1], (int)2);
        this.setupSessionFactory(0, true);
        this.setupSessionFactory(1, true);
        this.createAddressInfo(0, "queues.testAddress", RoutingType.ANYCAST, -1, false);
        this.createAddressInfo(1, "queues.testAddress", RoutingType.ANYCAST, -1, false);
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        for (int i = 0; i < 50; ++i) {
            int target = i % 2;
            int remote = (i + 1) % 2;
            this.closeConsumerAndConnectionConcurrently(target, remote);
        }
    }

    @Test
    public void testFailoverNonClusteredBrokersInteropWithCoreProducer() throws Exception {
        this.setupServer(0, true, true);
        this.setupServer(1, true, true);
        this.startServers(0, 1);
        ((AddressSettings)this.servers[0].getAddressSettingsRepository().getMatch("#")).setRedeliveryDelay(0L).setRedistributionDelay(0L);
        ((AddressSettings)this.servers[1].getAddressSettingsRepository().getMatch("#")).setRedeliveryDelay(0L).setRedistributionDelay(0L);
        this.setupSessionFactory(0, true);
        this.setupSessionFactory(1, true);
        this.createAddressInfo(0, "q", RoutingType.ANYCAST, -1, false);
        this.createAddressInfo(1, "q", RoutingType.ANYCAST, -1, false);
        this.createQueue(0, "q", "q", null, true, RoutingType.ANYCAST);
        this.createQueue(1, "q", "q", null, true, RoutingType.ANYCAST);
        int numMessagesPerNode = 1000;
        this.produceWithCoreTo(0, 1000);
        this.produceWithCoreTo(1, 1000);
        String zero = this.getServerUri(0);
        String one = this.getServerUri(1);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:(" + zero + "," + one + ")?jms.prefetchPolicy.all=10&randomize=false&timeout=400&reconnectDelay=500&useExponentialBackOff=false&initialReconnectDelay=500&nested.wireFormat.maxInactivityDuration=500&nested.wireFormat.maxInactivityDurationInitalDelay=500&nested.ignoreRemoteWireFormat=true&nested.soTimeout=500&nested.connectionTimeout=400&jms.connectResponseTimeout=400&jms.sendTimeout=400&jms.closeTimeout=400");
        factory.setWatchTopicAdvisories(false);
        CountDownLatch continueLatch = new CountDownLatch(1);
        final CountDownLatch received = new CountDownLatch(2000);
        Connection conn = factory.createConnection();
        conn.start();
        ((ActiveMQConnection)conn).setClientInternalExceptionListener(Throwable::printStackTrace);
        Session session = conn.createSession(false, 1);
        ActiveMQDestination dest = ActiveMQDestination.createDestination((String)"q", (byte)1);
        session.createConsumer((Destination)dest).setMessageListener(message -> {
            try {
                received.countDown();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        MessageRedistributionTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return received.getCount() <= 1000L;
            }
        }));
        this.servers[0].stop(false, true);
        MessageRedistributionTest.assertTrue((boolean)Wait.waitFor(() -> received.await(1L, TimeUnit.SECONDS)));
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceWithCoreTo(int serveId, int numMessagesPerNode) throws Exception {
        String targetUrl = this.getServerUri(serveId);
        try (Connection jmsConn = null;){
            org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory coreCf = ActiveMQJMSClient.createConnectionFactory((String)targetUrl, (String)("cf" + serveId));
            jmsConn = coreCf.createConnection();
            jmsConn.setClientID("theProducer");
            Session coreSession = jmsConn.createSession(false, 1);
            TextMessage msg = coreSession.createTextMessage("TEXT");
            Queue queue = coreSession.createQueue("q");
            MessageProducer producer = coreSession.createProducer((Destination)queue);
            for (int i = 0; i < numMessagesPerNode; ++i) {
                msg.setIntProperty("MM", i);
                msg.setIntProperty("SN", serveId);
                producer.send((Message)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdvisoriesNotClustered() throws Exception {
        this.setupServer(0, true, true);
        this.setupServer(1, true, true);
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, true, 0, 1);
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, true, 1, 0);
        this.startServers(0, 1);
        MessageRedistributionTest.waitForTopology((ActiveMQServer)this.servers[0], (int)2);
        MessageRedistributionTest.waitForTopology((ActiveMQServer)this.servers[1], (int)2);
        this.setupSessionFactory(0, true);
        this.setupSessionFactory(1, true);
        this.createAddressInfo(0, "testAddress", RoutingType.MULTICAST, -1, false);
        this.createAddressInfo(1, "testAddress", RoutingType.MULTICAST, -1, false);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        ActiveMQConnectionFactory factory2 = new ActiveMQConnectionFactory(this.getServerUri(1));
        Connection conn = null;
        Connection conn2 = null;
        CountDownLatch active = new CountDownLatch(1);
        try {
            conn = factory.createConnection();
            conn2 = factory2.createConnection();
            conn2.setClientID("id");
            conn2.start();
            Session session = conn.createSession(false, 1);
            Session session2 = conn2.createSession(false, 1);
            Topic dest = (Topic)ActiveMQDestination.createDestination((String)"testAddress", (byte)2);
            TopicSubscriber mySubscriber = session2.createDurableSubscriber(dest, "mySubscriber");
            MessageProducer producer = session.createProducer((Destination)dest);
            producer.send((Message)session.createTextMessage("test message"));
            Message message = mySubscriber.receive(5000L);
            SimpleString advQueue = new SimpleString("ActiveMQ.Advisory.TempQueue");
            SimpleString advTopic = new SimpleString("ActiveMQ.Advisory.TempTopic");
            Assert.assertEquals((String)"", (long)1L, (long)this.servers[0].getPostOffice().getBindingsForAddress(advQueue).getBindings().size());
            Assert.assertEquals((String)"", (long)1L, (long)this.servers[0].getPostOffice().getBindingsForAddress(advTopic).getBindings().size());
            Assert.assertEquals((String)"", (long)1L, (long)this.servers[1].getPostOffice().getBindingsForAddress(advQueue).getBindings().size());
            Assert.assertEquals((String)"", (long)1L, (long)this.servers[1].getPostOffice().getBindingsForAddress(advTopic).getBindings().size());
        }
        finally {
            conn.close();
            conn2.close();
        }
    }

    @Override
    protected boolean isResolveProtocols() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConsumerAndConnectionConcurrently(int targetNode, int remoteNode) throws Exception {
        String targetUri = this.getServerUri(targetNode);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(targetUri);
        CountDownLatch active = new CountDownLatch(1);
        try (Connection conn = null;){
            conn = factory.createConnection();
            conn.start();
            Session session = conn.createSession(false, 1);
            ActiveMQDestination dest = ActiveMQDestination.createDestination((String)"queue0", (byte)1);
            ConsumerThread consumer = new ConsumerThread(session, (Destination)dest);
            consumer.setMessageCount(0);
            consumer.setFinished(active);
            consumer.start();
            MessageRedistributionTest.assertTrue((String)"consumer takes too long to finish!", (boolean)active.await(5L, TimeUnit.SECONDS));
        }
        Wait.waitFor(() -> this.getRemoteQueueBinding(this.servers[remoteNode]) != null);
        RemoteQueueBinding remoteBinding = this.getRemoteQueueBinding(this.servers[remoteNode]);
        MessageRedistributionTest.assertNotNull((Object)remoteBinding);
        Wait.waitFor(() -> remoteBinding.consumerCount() >= 0);
        int count = remoteBinding.consumerCount();
        MessageRedistributionTest.assertTrue((String)("consumer count should never be negative " + count), (count >= 0 ? 1 : 0) != 0);
    }

    private RemoteQueueBinding getRemoteQueueBinding(ActiveMQServer server) throws Exception {
        ActiveMQServer remoteServer = server;
        Bindings bindings = remoteServer.getPostOffice().getBindingsForAddress(new SimpleString("queues.testaddress"));
        Collection bindingSet = bindings.getBindings();
        return this.getRemoteQueueBinding(bindingSet);
    }

    private RemoteQueueBinding getRemoteQueueBinding(Collection<Binding> bindingSet) {
        RemoteQueueBinding remoteBinding = null;
        for (Binding b : bindingSet) {
            if (!(b instanceof RemoteQueueBinding)) continue;
            remoteBinding = (RemoteQueueBinding)b;
            break;
        }
        return remoteBinding;
    }
}

