/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JMSUsecaseTest
extends BasicOpenWireTest {
    public int deliveryMode;
    public byte destinationType;

    @Parameterized.Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)1}, {1, (byte)5}, {2, (byte)1}, {2, (byte)5});
    }

    public JMSUsecaseTest(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @Test
    public void testQueueBrowser() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(this.deliveryMode);
        this.sendMessages(session, producer, 5);
        producer.close();
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(100L);
            JMSUsecaseTest.assertTrue((boolean)enumeration.hasMoreElements());
            Message m = (Message)enumeration.nextElement();
            JMSUsecaseTest.assertNotNull((Object)m);
            JMSUsecaseTest.assertEquals((Object)("" + i), (Object)((TextMessage)m).getText());
        }
        JMSUsecaseTest.assertFalse((boolean)enumeration.hasMoreElements());
    }
}

