/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenWireLargeMessageTest
extends BasicOpenWireTest {
    public SimpleString lmAddress = new SimpleString("LargeMessageAddress");
    public SimpleString lmDropAddress = new SimpleString("LargeMessageDropAddress");

    @Override
    @Before
    public void setUp() throws Exception {
        this.realStore = true;
        super.setUp();
        this.server.createQueue(new QueueConfiguration(this.lmAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration(this.lmDropAddress).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testSendLargeMessage() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.lmAddress.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            int size = 0x100000;
            byte[] bytes = new byte[size];
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(bytes);
            producer.send((Message)message);
        }
    }

    @Override
    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        addressSettingsMap.put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(new SimpleString("ActiveMQ.DLQ")).setAutoCreateAddresses(Boolean.valueOf(true)));
        addressSettingsMap.put(this.lmDropAddress.toString(), new AddressSettings().setMaxSizeBytes(102400L).setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP).setMessageCounterHistoryDayLimit(10).setRedeliveryDelay(0L).setMaxDeliveryAttempts(0));
    }

    @Test
    public void testSendReceiveLargeMessage() throws Exception {
        Queue queue;
        Session session;
        int size = 0x100000;
        byte[] bytes = new byte[size];
        try (Connection connection = this.factory.createConnection();){
            connection.start();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.lmAddress.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            bytes[0] = 1;
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(bytes);
            producer.send((Message)message);
        }
        this.server.stop();
        this.server.start();
        connection = this.factory.createConnection();
        var4_4 = null;
        try {
            connection.start();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.lmAddress.toString());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            BytesMessage m = (BytesMessage)consumer.receive();
            OpenWireLargeMessageTest.assertNotNull((Object)m);
            byte[] body = new byte[size];
            m.readBytes(body);
            OpenWireLargeMessageTest.assertArrayEquals((byte[])body, (byte[])bytes);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var4_4 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFastLargeMessageProducerDropOnPaging() throws Exception {
        AssertionLoggerHandler.startCapture();
        try {
            int size = 102400;
            byte[] bytes = new byte[size];
            try (Connection connection = this.factory.createConnection();){
                connection.start();
                try (Session session = connection.createSession(false, 1);){
                    Queue queue = session.createQueue(this.lmDropAddress.toString());
                    try (MessageProducer producer = session.createProducer((Destination)queue);){
                        producer.setDeliveryMode(1);
                        bytes[0] = 1;
                        BytesMessage message = session.createBytesMessage();
                        message.writeBytes(bytes);
                        PagingStore pageStore = this.server.getPagingManager().getPageStore(this.lmDropAddress);
                        while (!pageStore.isPaging()) {
                            producer.send((Message)message);
                        }
                        for (int i = 0; i < 10; ++i) {
                            producer.send((Message)message);
                        }
                        long messageCount = this.server.locateQueue(this.lmDropAddress).getMessageCount();
                        Assert.assertTrue((String)"The queue cannot be empty", (messageCount > 0L ? 1 : 0) != 0);
                        try (MessageConsumer messageConsumer = session.createConsumer((Destination)queue);){
                            for (long m = 0L; m < messageCount; ++m) {
                                if (messageConsumer.receive(2000L) != null) continue;
                                Assert.fail((String)"The messages are not finished yet");
                            }
                        }
                    }
                }
            }
            this.server.stop();
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"NullPointerException"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"It was not possible to delete message"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }
}

