/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class ValidateTransactionHealthTest
extends SpawnedTestBase {
    private static final Logger log = Logger.getLogger(ValidateTransactionHealthTest.class);
    private static final int OK = 10;

    @Test
    public void testAIO() throws Exception {
        this.internalTest("aio", this.getTestDir(), 10000L, 100, true, true, 1);
    }

    @Test
    public void testAIOHugeTransaction() throws Exception {
        this.internalTest("aio", this.getTestDir(), 10000L, 10000, true, true, 1);
    }

    @Test
    public void testAIOMultiThread() throws Exception {
        this.internalTest("aio", this.getTestDir(), 1000L, 100, true, true, 10);
    }

    @Test
    public void testAIONonTransactionalNoExternalProcess() throws Exception {
        this.internalTest("aio", this.getTestDir(), 1000L, 0, true, false, 10);
    }

    @Test
    public void testNIO() throws Exception {
        this.internalTest("nio", this.getTestDir(), 10000L, 100, true, true, 1);
    }

    @Test
    public void testNIOHugeTransaction() throws Exception {
        this.internalTest("nio", this.getTestDir(), 10000L, 10000, true, true, 1);
    }

    @Test
    public void testNIOMultiThread() throws Exception {
        this.internalTest("nio", this.getTestDir(), 1000L, 100, true, true, 10);
    }

    @Test
    public void testNIONonTransactional() throws Exception {
        this.internalTest("nio", this.getTestDir(), 10000L, 0, true, true, 1);
    }

    @Test
    public void testNIO2() throws Exception {
        this.internalTest("nio2", this.getTestDir(), 10000L, 100, true, true, 1);
    }

    @Test
    public void testNIO2HugeTransaction() throws Exception {
        this.internalTest("nio2", this.getTestDir(), 10000L, 10000, true, true, 1);
    }

    @Test
    public void testNIO2MultiThread() throws Exception {
        this.internalTest("nio2", this.getTestDir(), 1000L, 100, true, true, 10);
    }

    @Test
    public void testNIO2NonTransactional() throws Exception {
        this.internalTest("nio2", this.getTestDir(), 10000L, 0, true, true, 1);
    }

    @Test
    public void testMMap() throws Exception {
        this.internalTest("mmap", this.getTestDir(), 10000L, 100, true, true, 1);
    }

    @Test
    public void testMMAPHugeTransaction() throws Exception {
        this.internalTest("mmap", this.getTestDir(), 10000L, 10000, true, true, 1);
    }

    @Test
    public void testMMAPOMultiThread() throws Exception {
        this.internalTest("mmap", this.getTestDir(), 1000L, 100, true, true, 10);
    }

    @Test
    public void testMMAPNonTransactional() throws Exception {
        this.internalTest("mmap", this.getTestDir(), 10000L, 0, true, true, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTest(String type, String journalDir, long numberOfRecords, int transactionSize, boolean append, boolean externalProcess, int numberOfThreads) throws Exception {
        try {
            if (type.equals("aio") && !LibaioContext.isLoaded()) {
                log.warn((Object)"AIO not found, test being ignored on this platform");
                return;
            }
            if (append) {
                if (externalProcess) {
                    Process process = SpawnedVMSupport.spawnVM((String)ValidateTransactionHealthTest.class.getCanonicalName(), (String[])new String[]{type, journalDir, Long.toString(numberOfRecords), Integer.toString(transactionSize), Integer.toString(numberOfThreads)});
                    process.waitFor();
                    Assert.assertEquals((long)10L, (long)process.exitValue());
                } else {
                    JournalImpl journal = ValidateTransactionHealthTest.appendData(type, journalDir, numberOfRecords, transactionSize, numberOfThreads);
                    journal.stop();
                }
            }
            this.reload(type, journalDir, numberOfRecords, numberOfThreads);
        }
        finally {
            File file = new File(journalDir);
            ValidateTransactionHealthTest.deleteDirectory((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(String type, String journalDir, long numberOfRecords, int numberOfThreads) throws Exception {
        JournalImpl journal = ValidateTransactionHealthTest.createJournal(type, journalDir);
        journal.start();
        try {
            Loader loadTest = new Loader(numberOfRecords);
            journal.load((LoaderCallback)loadTest);
            Assert.assertEquals((long)(numberOfRecords * (long)numberOfThreads), (long)loadTest.numberOfAdds);
            Assert.assertEquals((long)0L, (long)loadTest.numberOfPreparedTransactions);
            Assert.assertEquals((long)0L, (long)loadTest.numberOfUpdates);
            Assert.assertEquals((long)0L, (long)loadTest.numberOfDeletes);
            if (loadTest.ex != null) {
                throw loadTest.ex;
            }
        }
        finally {
            journal.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.err.println("Use: java -cp <classpath> " + ValidateTransactionHealthTest.class.getCanonicalName() + " aio|nio|mmap <journalDirectory> <NumberOfElements> <TransactionSize> <NumberOfThreads>");
            System.exit(-1);
        }
        String journalType = args[0];
        String journalDir = args[1];
        long numberOfElements = Long.parseLong(args[2]);
        int transactionSize = Integer.parseInt(args[3]);
        int numberOfThreads = Integer.parseInt(args[4]);
        try {
            ValidateTransactionHealthTest.appendData(journalType, journalDir, numberOfElements, transactionSize, numberOfThreads);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.exit(-1);
        }
        Runtime.getRuntime().halt(10);
    }

    public static JournalImpl appendData(String journalType, String journalDir, long numberOfElements, int transactionSize, int numberOfThreads) throws Exception {
        JournalImpl journal = ValidateTransactionHealthTest.createJournal(journalType, journalDir);
        journal.start();
        journal.load(new LoaderCallback(){

            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
            }

            public void addRecord(RecordInfo info) {
            }

            public void deleteRecord(long id) {
            }

            public void updateRecord(RecordInfo info) {
            }

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }
        });
        LocalThread[] threads = new LocalThread[numberOfThreads];
        AtomicLong sequenceTransaction = new AtomicLong();
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new LocalThread(journal, numberOfElements, transactionSize, sequenceTransaction);
            threads[i].start();
        }
        Exception e = null;
        for (LocalThread t : threads) {
            t.join();
            if (t.e == null) continue;
            e = t.e;
        }
        if (e != null) {
            throw e;
        }
        journal.flush();
        return journal;
    }

    public static JournalImpl createJournal(String journalType, String journalDir) {
        JournalImpl journal = new JournalImpl(0xA00000, 2, 2, 0, 0, ValidateTransactionHealthTest.getFactory(journalType, journalDir, 0xA00000), "journaltst", "tst", 500);
        return journal;
    }

    public static SequentialFileFactory getFactory(String factoryType, String directory, int fileSize) {
        if (factoryType.equals("aio")) {
            return new AIOSequentialFileFactory(new File(directory), 501760, 500000, 10, false);
        }
        if (factoryType.equals("nio2")) {
            return new NIOSequentialFileFactory(new File(directory), true, 1);
        }
        if (factoryType.equals("mmap")) {
            return new MappedSequentialFileFactory(new File(directory), fileSize, false, 0, 0, null);
        }
        return new NIOSequentialFileFactory(new File(directory), false, 1);
    }

    static class LocalThread
    extends Thread {
        final JournalImpl journal;
        final long numberOfElements;
        final int transactionSize;
        final AtomicLong nextID;
        Exception e;

        LocalThread(JournalImpl journal, long numberOfElements, int transactionSize, AtomicLong nextID) {
            this.journal = journal;
            this.numberOfElements = numberOfElements;
            this.transactionSize = transactionSize;
            this.nextID = nextID;
        }

        @Override
        public void run() {
            try {
                int transactionCounter = 0;
                long transactionId = this.nextID.incrementAndGet();
                for (long i = 0L; i < this.numberOfElements; ++i) {
                    long id = this.nextID.incrementAndGet();
                    ByteBuffer buffer = ByteBuffer.allocate(1536);
                    buffer.putLong(id);
                    if (this.transactionSize != 0) {
                        this.journal.appendAddRecordTransactional(transactionId, id, (byte)99, buffer.array());
                        if (++transactionCounter != this.transactionSize) continue;
                        log.debug((Object)("Commit transaction " + transactionId));
                        this.journal.appendCommitRecord(transactionId, true);
                        transactionCounter = 0;
                        transactionId = this.nextID.incrementAndGet();
                        continue;
                    }
                    this.journal.appendAddRecord(id, (byte)99, buffer.array(), false);
                }
                if (transactionCounter != 0) {
                    this.journal.appendCommitRecord(transactionId, true);
                }
                if (this.transactionSize == 0) {
                    this.journal.debugWait();
                }
            }
            catch (Exception e) {
                this.e = e;
            }
        }
    }

    static class Loader
    implements LoaderCallback {
        int numberOfPreparedTransactions = 0;
        int numberOfAdds = 0;
        int numberOfDeletes = 0;
        int numberOfUpdates = 0;
        long expectedRecords = 0L;
        Exception ex = null;
        long lastID = 0L;

        Loader(long expectedRecords) {
            this.expectedRecords = expectedRecords;
        }

        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
            ++this.numberOfPreparedTransactions;
        }

        public void addRecord(RecordInfo info) {
            ByteBuffer buffer;
            long recordValue;
            if (info.id == this.lastID) {
                log.debug((Object)("id = " + info.id + " last id = " + this.lastID));
            }
            if ((recordValue = (buffer = ByteBuffer.wrap(info.data)).getLong()) != info.id) {
                this.ex = new Exception("Content not as expected (" + recordValue + " != " + info.id + ")");
            }
            this.lastID = info.id;
            ++this.numberOfAdds;
        }

        public void deleteRecord(long id) {
            ++this.numberOfDeletes;
        }

        public void updateRecord(RecordInfo info) {
            ++this.numberOfUpdates;
        }

        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }
    }
}

