/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.tests.integration.cluster.failover.BackupSyncJournalTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class BackupSyncLargeMessageTest
extends BackupSyncJournalTest {
    protected void assertMessageBody(int i, ClientMessage message) {
        BackupSyncLargeMessageTest.assertLargeMessageBody(i, message);
    }

    @Override
    protected ServerLocatorInternal getServerLocator() throws Exception {
        return (ServerLocatorInternal)super.getServerLocator().setMinLargeMessageSize(1024);
    }

    @Override
    protected boolean supportsRetention() {
        return false;
    }

    protected void setBody(int i, ClientMessage message) {
        BackupSyncLargeMessageTest.setLargeMessageBody(i, message);
    }

    @Test
    public void testDeleteLargeMessages() throws Exception {
        this.setNumberOfMessages(200);
        File dir = new File(this.backupServer.getServer().getConfiguration().getLargeMessagesDirectory());
        BackupSyncLargeMessageTest.assertEquals((String)"Should not have any large messages... previous test failed to clean up?", (long)0L, (long)this.getAllMessageFileIds(dir).size());
        this.createProducerSendSomeMessages();
        this.startBackupFinishSyncing();
        this.receiveMsgsInRange(0, this.getNumberOfMessages() / 2);
        this.finishSyncAndFailover();
        int target = this.getNumberOfMessages() / 2;
        long timeout = System.currentTimeMillis() + 5000L;
        while (this.getAllMessageFileIds(dir).size() != target && System.currentTimeMillis() < timeout) {
            Thread.sleep(50L);
        }
        BackupSyncLargeMessageTest.assertEquals((String)"we really ought to delete these after delivery", (long)target, (long)this.getAllMessageFileIds(dir).size());
    }

    @Test
    public void testDeleteLargeMessagesDuringSync() throws Exception {
        this.setNumberOfMessages(200);
        File backupLMdir = new File(this.backupServer.getServer().getConfiguration().getLargeMessagesDirectory());
        File liveLMDir = new File(this.liveServer.getServer().getConfiguration().getLargeMessagesDirectory());
        BackupSyncLargeMessageTest.assertEquals((String)"Should not have any large messages... previous test failed to clean up?", (long)0L, (long)this.getAllMessageFileIds(backupLMdir).size());
        this.createProducerSendSomeMessages();
        this.backupServer.start();
        BackupSyncLargeMessageTest.waitForComponent((ActiveMQComponent)this.backupServer.getServer(), (long)5L);
        this.receiveMsgsInRange(0, this.getNumberOfMessages() / 2);
        this.startBackupFinishSyncing();
        Thread.sleep(500L);
        this.liveServer.getServer().stop();
        this.backupServer.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        this.backupServer.stop();
        Set<Long> backupLM = this.getAllMessageFileIds(backupLMdir);
        Set<Long> liveLM = this.getAllMessageFileIds(liveLMDir);
        BackupSyncLargeMessageTest.assertEquals((String)"live and backup should have the same files ", liveLM, backupLM);
        BackupSyncLargeMessageTest.assertEquals((String)("we really ought to delete these after delivery: " + backupLM), (long)(this.getNumberOfMessages() / 2), (long)backupLM.size());
        BackupSyncLargeMessageTest.assertEquals((String)"we really ought to delete these after delivery", (long)(this.getNumberOfMessages() / 2), (long)this.getAllMessageFileIds(backupLMdir).size());
    }

    @Test
    public void testBackupStartsWhenLiveIsReceivingLargeMessage() throws Exception {
        final ClientSession session = this.addClientSession(this.sessionFactory.createSession(true, true));
        session.createQueue(new QueueConfiguration(FailoverTestBase.ADDRESS));
        final ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        final ClientMessage message = session.createMessage(true);
        int largeMessageSize = 1024000;
        message.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream((long)1024000L));
        final AtomicBoolean caughtException = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    latch.countDown();
                    producer.send((Message)message);
                    BackupSyncLargeMessageTest.this.sendMessages(session, producer, 20);
                    session.commit();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                    caughtException.set(true);
                }
                finally {
                    latch2.countDown();
                }
            }
        };
        Executors.defaultThreadFactory().newThread(r).start();
        BackupSyncLargeMessageTest.waitForLatch((CountDownLatch)latch);
        this.startBackupFinishSyncing();
        ActiveMQTestBase.waitForLatch((CountDownLatch)latch2);
        this.crash(session);
        BackupSyncLargeMessageTest.assertFalse((String)"no exceptions while sending message", (boolean)caughtException.get());
        session.start();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        ClientMessage msg = consumer.receive(2000L);
        ActiveMQBuffer buffer = msg.getBodyBuffer();
        for (int j = 0; j < 1024000; ++j) {
            Assert.assertTrue((String)("large msg , expecting 1024000 bytes, got " + j), (boolean)buffer.readable());
            Assert.assertEquals((String)("equal at " + j), (long)ActiveMQTestBase.getSamplebyte((long)j), (long)buffer.readByte());
        }
        this.receiveMessages(consumer, 0, 20, true);
        BackupSyncLargeMessageTest.assertNull((String)"there should be no more messages!", (Object)consumer.receiveImmediate());
        consumer.close();
        session.commit();
    }

    private Set<Long> getAllMessageFileIds(File dir) {
        TreeSet<Long> idsOnBkp = new TreeSet<Long>();
        String[] fileList = dir.list();
        if (fileList != null) {
            for (String filename : fileList) {
                if (!filename.endsWith(".msg")) continue;
                idsOnBkp.add(Long.valueOf(filename.split("\\.")[0]));
            }
        }
        return idsOnBkp;
    }
}

