/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.version.impl.VersionImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IncompatibleVersionTest
extends SpawnedTestBase {
    private static final Logger log = Logger.getLogger(IncompatibleVersionTest.class);
    private static final String WORD_START = "&*STARTED&*";
    private ActiveMQServer server;
    private CoreRemotingConnection connection;
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, false);
        this.server.getConfiguration().setConnectionTTLOverride(500L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        ClientSessionFactory csf = this.createSessionFactory(this.locator);
        this.connection = (CoreRemotingConnection)csf.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.destroy();
        IncompatibleVersionTest.closeServerLocator((ServerLocator)this.locator);
        IncompatibleVersionTest.stopComponent((ActiveMQComponent)this.server);
        SpawnedVMSupport.forceKill();
        super.tearDown();
    }

    @Test
    public void testCompatibleClientVersion() throws Exception {
        this.doTestClientVersionCompatibility(true);
    }

    @Test
    public void testIncompatibleClientVersion() throws Exception {
        this.doTestClientVersionCompatibility(false);
    }

    @Test
    public void testCompatibleClientVersionWithRealConnection1() throws Throwable {
        IncompatibleVersionTest.assertTrue((boolean)this.doTestClientVersionCompatibilityWithRealConnection("1-3,5,7-10", 1));
    }

    @Test
    public void testCompatibleClientVersionWithRealConnection2() throws Throwable {
        IncompatibleVersionTest.assertTrue((boolean)this.doTestClientVersionCompatibilityWithRealConnection("1-3,5,7-10", 5));
    }

    @Test
    public void testCompatibleClientVersionWithRealConnection3() throws Throwable {
        IncompatibleVersionTest.assertTrue((boolean)this.doTestClientVersionCompatibilityWithRealConnection("1-3,5,7-10", 10));
    }

    @Test
    public void testIncompatibleClientVersionWithRealConnection1() throws Throwable {
        IncompatibleVersionTest.assertFalse((boolean)this.doTestClientVersionCompatibilityWithRealConnection("1-3,5,7-10", 0));
    }

    @Test
    public void testIncompatibleClientVersionWithRealConnection2() throws Throwable {
        IncompatibleVersionTest.assertFalse((boolean)this.doTestClientVersionCompatibilityWithRealConnection("1-3,5,7-10", 4));
    }

    @Test
    public void testIncompatibleClientVersionWithRealConnection3() throws Throwable {
        IncompatibleVersionTest.assertFalse((boolean)this.doTestClientVersionCompatibilityWithRealConnection("1-3,5,7-10", 100));
    }

    private void doTestClientVersionCompatibility(boolean compatible) throws Exception {
        Channel channel1 = this.connection.getChannel(1L, -1);
        long sessionChannelID = this.connection.generateChannelID();
        int version = VersionLoader.getVersion().getIncrementingVersion();
        if (!compatible) {
            version = -1;
        }
        CreateSessionMessage request = new CreateSessionMessage(RandomUtil.randomString(), sessionChannelID, version, null, null, 102400, false, true, true, false, -1, null);
        if (compatible) {
            CreateSessionResponseMessage packet = (CreateSessionResponseMessage)channel1.sendBlocking((Packet)request, (byte)31);
            IncompatibleVersionTest.assertNotNull((Object)packet);
            IncompatibleVersionTest.assertEquals((long)1L, (long)this.server.getConnectionCount());
        } else {
            try {
                channel1.sendBlocking((Packet)request, (byte)31);
                IncompatibleVersionTest.fail();
            }
            catch (ActiveMQIncompatibleClientServerException packet) {
            }
            catch (ActiveMQException e) {
                IncompatibleVersionTest.fail((String)("Invalid Exception type:" + e.getType()));
            }
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + 3L * this.server.getConfiguration().getConnectionTtlCheckInterval() && this.server.getConnectionCount() != 0) {
            }
            IncompatibleVersionTest.assertEquals((long)0L, (long)this.server.getConnectionCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doTestClientVersionCompatibilityWithRealConnection(String verList, int ver) throws Throwable {
        String propFileName = "compatibility-test-activemq-version.properties";
        String serverStartedString = "IncompatibleVersionTest---server---started";
        Properties prop = new Properties();
        InputStream in = VersionImpl.class.getClassLoader().getResourceAsStream("activemq-version.properties");
        prop.load(in);
        prop.setProperty("activemq.version.compatibleVersionList", verList);
        prop.setProperty("activemq.version.incrementingVersion", Integer.toString(ver));
        prop.store(new FileOutputStream("target/test-classes/" + propFileName), null);
        Process serverProcess = null;
        Process client = null;
        boolean result = false;
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            };
            serverProcess = SpawnedVMSupport.spawnVMWithLogMacher((String)WORD_START, (Runnable)runnable, (String)"org.apache.activemq.artemis.tests.integration.client.IncompatibleVersionTest", (String[])new String[]{"-Dactivemq.version.property.filename=" + propFileName}, (boolean)true, (String[])new String[]{"server", serverStartedString});
            Assert.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
            client = SpawnedVMSupport.spawnVM((String)"org.apache.activemq.artemis.tests.integration.client.IncompatibleVersionTest", (String[])new String[]{"-Dactivemq.version.property.filename=" + propFileName}, (String[])new String[]{"client"});
            if (client.waitFor() == 0) {
                result = true;
            }
        }
        finally {
            if (serverProcess != null) {
                try {
                    serverProcess.destroy();
                }
                catch (Throwable throwable) {}
            }
            if (client != null) {
                try {
                    client.destroy();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        IncompatibleVersionTest incompatibleVersionTest = new IncompatibleVersionTest();
        incompatibleVersionTest.execute(args);
    }

    private void execute(String[] args) throws Exception {
        if (args[0].equals("server")) {
            ServerStarter ss = new ServerStarter();
            ss.perform(args[1]);
        } else if (args[0].equals("client")) {
            ClientStarter cs = new ClientStarter();
            cs.perform();
        } else {
            throw new Exception("args[0] must be \"server\" or \"client\"");
        }
    }

    private class ClientStarter {
        private ClientStarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform() throws Exception {
            ServerLocator locator = null;
            ClientSessionFactory sf = null;
            try {
                locator = IncompatibleVersionTest.this.createNettyNonHALocator();
                sf = locator.createSessionFactory();
                ClientSession session = sf.createSession(false, true, true);
                log.debug((Object)("### client: connected. server incrementingVersion = " + session.getVersion()));
                session.close();
            }
            catch (Throwable throwable) {
                ActiveMQTestBase.closeSessionFactory(sf);
                ActiveMQTestBase.closeServerLocator((ServerLocator)locator);
                throw throwable;
            }
            ActiveMQTestBase.closeSessionFactory((ClientSessionFactory)sf);
            ActiveMQTestBase.closeServerLocator((ServerLocator)locator);
        }
    }

    private static class ServerStarter {
        private ServerStarter() {
        }

        public void perform(String startedString) throws Exception {
            ConfigurationImpl config = new ConfigurationImpl().setSecurityEnabled(false).addAcceptorConfiguration(new TransportConfiguration(ActiveMQTestBase.NETTY_ACCEPTOR_FACTORY));
            ActiveMQServer server = ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false);
            server.start();
            while (!server.isStarted()) {
                System.out.println("Still starting");
                Thread.sleep(100L);
            }
            System.out.println(IncompatibleVersionTest.WORD_START);
            log.debug((Object)("### server: " + startedString));
        }
    }
}

