/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class ConsumerStuckTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ConsumerTestQueue");

    protected boolean isNetty() {
        return true;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.isNetty());
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientStuckTest() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setConnectionTTL(1000L).setClientFailureCheckPeriod(100L).setConsumerWindowSize(0xA00000).setCallTimeout(1000L);
        ClientSessionFactory sf = locator.createSessionFactory();
        ((ClientSessionFactoryImpl)sf).stopPingingAfterOne();
        RemotingConnectionImpl remotingConnection = (RemotingConnectionImpl)sf.getConnection();
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 10000;
        for (int i = 0; i < 10000; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((Message)message);
        }
        final ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        final NettyConnection nettyConnection = (NettyConnection)remotingConnection.getTransportConnection();
        Thread tReceive = new Thread(){

            @Override
            public void run() {
                boolean first = true;
                try {
                    while (!Thread.interrupted()) {
                        ClientMessage received = consumer.receive(500L);
                        ConsumerStuckTest.this.instanceLog.debug((Object)("Received " + received));
                        if (first) {
                            first = false;
                            nettyConnection.getNettyChannel().config().setAutoRead(false);
                        }
                        if (received == null) continue;
                        received.acknowledge();
                    }
                }
                catch (Throwable e) {
                    Thread.currentThread().interrupt();
                    e.printStackTrace();
                }
            }
        };
        tReceive.start();
        try {
            ConsumerStuckTest.assertEquals((long)1L, (long)this.server.getSessions().size());
            this.instanceLog.debug((Object)("sessions = " + this.server.getSessions().size()));
            ConsumerStuckTest.assertEquals((long)1L, (long)this.server.getConnectionCount());
            long timeout = System.currentTimeMillis() + 20000L;
            long timeStart = System.currentTimeMillis();
            while (timeout > System.currentTimeMillis() && (this.server.getSessions().size() != 0 || this.server.getConnectionCount() != 0)) {
                Thread.sleep(10L);
            }
            this.instanceLog.debug((Object)("Time = " + System.currentTimeMillis() + " time diff = " + (System.currentTimeMillis() - timeStart) + ", connections Size = " + this.server.getConnectionCount() + " sessions = " + this.server.getSessions().size()));
            if (this.server.getSessions().size() != 0) {
                System.out.println(ConsumerStuckTest.threadDump((String)"Thread dump"));
                ConsumerStuckTest.fail((String)"The cleanup wasn't able to finish cleaning the session. It's probably stuck, look at the thread dump generated by the test for more information");
            }
            this.instanceLog.debug((Object)("Size = " + this.server.getConnectionCount()));
            this.instanceLog.debug((Object)("sessions = " + this.server.getSessions().size()));
            if (this.server.getSessions().size() != 0) {
                System.out.println(ConsumerStuckTest.threadDump((String)"Thread dump"));
                ConsumerStuckTest.fail((String)"The cleanup wasn't able to finish cleaning the session. It's probably stuck, look at the thread dump generated by the test for more information");
            }
            ConsumerStuckTest.assertEquals((long)0L, (long)this.server.getConnectionCount());
        }
        finally {
            nettyConnection.getNettyChannel().config().setAutoRead(true);
            tReceive.interrupt();
            tReceive.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientStuckTestWithDirectDelivery() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator().setConnectionTTL(1000L).setClientFailureCheckPeriod(100L).setConsumerWindowSize(0xA00000).setCallTimeout(1000L);
        ClientSessionFactory sf = locator.createSessionFactory();
        ((ClientSessionFactoryImpl)sf).stopPingingAfterOne();
        RemotingConnectionImpl remotingConnection = (RemotingConnectionImpl)sf.getConnection();
        ClientSession session = sf.createSession(false, true, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        int numMessages = 10000;
        final ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        final NettyConnection nettyConnection = (NettyConnection)remotingConnection.getTransportConnection();
        Thread tReceive = new Thread(){

            @Override
            public void run() {
                boolean first = true;
                try {
                    while (!Thread.interrupted()) {
                        ClientMessage received = consumer.receive(500L);
                        ConsumerStuckTest.this.instanceLog.debug((Object)("Received " + received));
                        if (first) {
                            first = false;
                            nettyConnection.getNettyChannel().config().setAutoRead(false);
                        }
                        if (received == null) continue;
                        received.acknowledge();
                    }
                }
                catch (Throwable e) {
                    Thread.currentThread().interrupt();
                    e.printStackTrace();
                }
            }
        };
        tReceive.start();
        Thread sender = new Thread(){

            @Override
            public void run() {
                try (ServerLocator locator = ConsumerStuckTest.this.createNettyNonHALocator();
                     ClientSessionFactory factory = locator.createSessionFactory();
                     ClientSession session = factory.createSession(false, true, true, true);
                     ClientProducer producer = session.createProducer(ConsumerStuckTest.this.QUEUE);){
                    for (int i = 0; i < 10000; ++i) {
                        ClientMessage message = ConsumerStuckTest.this.createTextMessage(session, "m" + i);
                        producer.send((Message)message);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        sender.start();
        try {
            long timeout = System.currentTimeMillis() + 20000L;
            while (System.currentTimeMillis() < timeout && this.server.getSessions().size() != 2) {
                Thread.sleep(10L);
            }
            ConsumerStuckTest.assertEquals((long)2L, (long)this.server.getSessions().size());
            this.instanceLog.debug((Object)("sessions = " + this.server.getSessions().size()));
            ConsumerStuckTest.assertEquals((long)2L, (long)this.server.getConnectionCount());
            timeout = System.currentTimeMillis() + 20000L;
            while (System.currentTimeMillis() < timeout && this.server.getSessions().size() != 1) {
                Thread.sleep(10L);
            }
            this.instanceLog.debug((Object)("Size = " + this.server.getConnectionCount()));
            this.instanceLog.debug((Object)("sessions = " + this.server.getSessions().size()));
            if (this.server.getSessions().size() != 1) {
                System.out.println(ConsumerStuckTest.threadDump((String)"Thread dump"));
                ConsumerStuckTest.fail((String)"The cleanup wasn't able to finish cleaning the session. It's probably stuck, look at the thread dump generated by the test for more information");
            }
            sender.join();
            timeout = System.currentTimeMillis() + 20000L;
            while (System.currentTimeMillis() < timeout && this.server.getConnectionCount() != 0) {
                Thread.sleep(10L);
            }
            ConsumerStuckTest.assertEquals((long)0L, (long)this.server.getConnectionCount());
        }
        finally {
            nettyConnection.getNettyChannel().config().setAutoRead(true);
            tReceive.interrupt();
            tReceive.join();
        }
    }
}

