/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.largemessages;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeBody;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AMQPLargeMessageSizeTest
extends ActiveMQTestBase {
    @Test
    public void testAMQPMockLargeMessageSize() throws Exception {
        AMQPLargeMessage amqpLargeMessage = new AMQPLargeMessage(1L, 0L, null, null, null, (LargeBody)new MockLargeBody(123456L));
        Assert.assertTrue((amqpLargeMessage.getWholeMessageSize() >= 123456L ? 1 : 0) != 0);
    }

    @Test
    public void testCoreMockLargeMessageSize() throws Exception {
        LargeServerMessageImpl largeServerMessage = new LargeServerMessageImpl(0, 1L, (StorageManager)new MockSM(123456L), null);
        Assert.assertTrue((largeServerMessage.getWholeMessageSize() >= 123456L ? 1 : 0) != 0);
    }

    private static class MockLargeBody
    extends LargeBody {
        final long size;

        MockLargeBody(long size) {
            super(null, null);
            this.size = size;
        }

        public long getBodySize() {
            return this.size;
        }
    }

    private static class MockFileSize
    implements SequentialFile {
        final long size;

        MockFileSize(long size) {
            this.size = size;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean exists() {
            return false;
        }

        public void open() throws Exception {
        }

        public void open(int maxIO, boolean useExecutor) throws Exception {
        }

        public ByteBuffer map(int position, long size) throws IOException {
            return null;
        }

        public boolean fits(int size) {
            return false;
        }

        public int calculateBlockStart(int position) throws Exception {
            return 0;
        }

        public String getFileName() {
            return null;
        }

        public void fill(int size) throws Exception {
        }

        public void delete() throws IOException, InterruptedException, ActiveMQException {
        }

        public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws Exception {
        }

        public void write(ActiveMQBuffer bytes, boolean sync) throws Exception {
        }

        public void write(EncodingSupport bytes, boolean sync, IOCallback callback) throws Exception {
        }

        public void write(EncodingSupport bytes, boolean sync) throws Exception {
        }

        public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        }

        public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        }

        public void blockingWriteDirect(ByteBuffer bytes, boolean sync, boolean releaseBuffer) throws Exception {
        }

        public int read(ByteBuffer bytes, IOCallback callback) throws Exception {
            return 0;
        }

        public int read(ByteBuffer bytes) throws Exception {
            return 0;
        }

        public void position(long pos) throws IOException {
        }

        public long position() {
            return 0L;
        }

        public void close() throws Exception {
        }

        public void sync() throws IOException {
        }

        public long size() throws Exception {
            return this.size;
        }

        public void renameTo(String newFileName) throws Exception {
        }

        public SequentialFile cloneFile() {
            return null;
        }

        public void copyTo(SequentialFile newFileName) throws Exception {
        }

        public void setTimedBuffer(TimedBuffer buffer) {
        }

        public File getJavaFile() {
            return null;
        }
    }

    private static class MockSM
    extends NullStorageManager {
        final long size;

        MockSM(long size) {
            this.size = size;
        }

        public SequentialFile createFileForLargeMessage(long messageID, boolean durable) {
            return new MockFileSize(this.size);
        }

        public SequentialFile createFileForLargeMessage(long messageID, StorageManager.LargeMessageExtension extension) {
            return new MockFileSize(this.size);
        }
    }
}

