/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Assert;
import org.junit.Test;

public class AmqpExpiredMessageTest
extends AmqpClientTestSupport {
    @Test(timeout=60000L)
    public void testSendMessageThatIsAlreadyExpiredUsingAbsoluteTime() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() - 5000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        AmqpExpiredMessageTest.assertNull((Object)received);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testExpiryThroughTTL() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", (Object)"Value1");
        sender.send(message);
        sender.close();
        Thread.sleep(100L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        AmqpExpiredMessageTest.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
        this.server.stop();
        this.server.start();
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        AmqpExpiredMessageTest.assertNotNull((Object)dlqView);
        Wait.assertEquals((long)1L, () -> ((Queue)dlqView).getMessageCount());
        client = this.createAmqpClient();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiverDLQ = session.createReceiver(this.getDeadLetterAddress());
        receiverDLQ.flow(1);
        received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
        AmqpExpiredMessageTest.assertNotNull((String)"Should have read message from DLQ", (Object)received);
        AmqpExpiredMessageTest.assertEquals((long)0L, (long)received.getTimeToLive());
        AmqpExpiredMessageTest.assertNotNull((Object)received);
        AmqpExpiredMessageTest.assertEquals((Object)"Value1", (Object)received.getApplicationProperty("key1"));
        connection.close();
    }

    @Test(timeout=60000L)
    public void testRetryExpiry() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", (Object)"Value1");
        sender.send(message);
        message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setBytes(new byte[512000]);
        sender.send(message);
        sender.close();
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        Wait.assertEquals((long)2L, () -> ((Queue)dlqView).getMessageCount());
        Assert.assertEquals((long)2L, (long)dlqView.retryMessages(null));
        Wait.assertEquals((long)0L, () -> ((Queue)dlqView).getMessageCount());
        Wait.assertEquals((long)2L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(2);
        for (int i = 0; i < 2; ++i) {
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpExpiredMessageTest.assertNotNull((Object)received);
            received.accept();
        }
        connection.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((Queue)dlqView).getMessageCount());
    }

    @Test(timeout=60000L)
    public void testExpiryThroughTTLValidateAnnotation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(1L);
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", (Object)"Value1");
        sender.send(message);
        sender.close();
        Thread.sleep(100L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        AmqpExpiredMessageTest.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
        this.server.stop();
        this.server.start();
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        AmqpExpiredMessageTest.assertNotNull((Object)dlqView);
        Wait.assertEquals((long)1L, () -> ((Queue)dlqView).getMessageCount());
        client = this.createAmqpClient();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiverDLQ = session.createReceiver(this.getDeadLetterAddress(), "\"m.x-opt-ORIG-ADDRESS\"='" + this.getQueueName() + "'");
        receiverDLQ.flow(1);
        received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)this.getQueueName(), (Object)received.getMessageAnnotation("x-opt-ORIG-ADDRESS"));
        receiverDLQ.close();
        receiverDLQ = session.createReceiver(this.getDeadLetterAddress(), "_AMQ_ORIG_ADDRESS='" + this.getQueueName() + "'");
        receiverDLQ.flow(1);
        received = receiverDLQ.receive(5L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)this.getQueueName(), (Object)received.getMessageAnnotation("x-opt-ORIG-ADDRESS"));
        Assert.assertNotNull((Object)received);
        received.accept();
        AmqpExpiredMessageTest.assertNotNull((String)"Should have read message from DLQ", (Object)received);
        AmqpExpiredMessageTest.assertEquals((long)0L, (long)received.getTimeToLive());
        AmqpExpiredMessageTest.assertNotNull((Object)received);
        AmqpExpiredMessageTest.assertEquals((Object)"Value1", (Object)received.getApplicationProperty("key1"));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testExpiryQpidJMS() throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", this.getBrokerAmqpConnectionURI().toString());
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            MessageProducer sender = session.createProducer((Destination)queue);
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            AmqpExpiredMessageTest.assertNotNull((Object)queueView);
            sender.setTimeToLive(1L);
            TextMessage message = session.createTextMessage("Test-Message");
            message.setStringProperty("key1", "Value1");
            sender.send((Message)message);
            sender.close();
            Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
            Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
            AmqpExpiredMessageTest.assertNotNull((Object)dlqView);
            Wait.assertEquals((long)1L, () -> ((Queue)dlqView).getMessageCount());
            connection.start();
            jakarta.jms.Queue queueDLQ = session.createQueue(this.getDeadLetterAddress());
            MessageConsumer receiverDLQ = session.createConsumer((Destination)queueDLQ, "\"m.x-opt-ORIG-ADDRESS\"='" + this.getQueueName() + "'");
            Message received = receiverDLQ.receive(5000L);
            Assert.assertNotNull((Object)received);
            receiverDLQ.close();
        }
    }

    @Test(timeout=60000L)
    public void testSendMessageThatIsNotExpiredUsingAbsoluteTime() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() + 5000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpExpiredMessageTest.assertNotNull((Object)received);
        AmqpExpiredMessageTest.assertEquals((long)0L, (long)queueView.getMessagesExpired());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSendMessageThatIsExiredUsingAbsoluteTimeWithLongTTL() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() - 5000L);
        message.setTimeToLive(60000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        AmqpExpiredMessageTest.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSendMessageThatIsExpiredUsingTTLWhenAbsoluteIsZero() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(0L);
        message.setTimeToLive(100L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((Long)1L, () -> ((Queue)queueView).getMessagesExpired(), (long)10000L, (long)10L);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        AmqpExpiredMessageTest.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSendMessageThatIsNotExpiredUsingAbsoluteTimeWithElspsedTTL() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setAbsoluteExpiryTime(System.currentTimeMillis() + 5000L);
        message.setTimeToLive(10L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpExpiredMessageTest.assertNotNull((Object)received);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSendMessageThatIsNotExpiredUsingTimeToLive() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(5000L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpExpiredMessageTest.assertNotNull((Object)received);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSendMessageThenAllowToExpiredUsingTimeToLive() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setTimeToLive(10L);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        Thread.sleep(50L);
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(1);
        AmqpMessage received = receiver.receiveNoWait();
        AmqpExpiredMessageTest.assertNull((Object)received);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessagesExpired());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testExpiredMessageLandsInDLQ() throws Throwable {
        this.internalSendExpiry(false);
    }

    @Test(timeout=60000L)
    public void testExpiredMessageLandsInDLQAndExistsAfterRestart() throws Throwable {
        this.internalSendExpiry(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalSendExpiry(boolean restartServer) throws Throwable {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            AmqpMessage message = new AmqpMessage();
            message.setDurable(true);
            message.setText("Test-Message");
            message.setDeliveryAnnotation("shouldDisappear", (Object)1);
            message.setAbsoluteExpiryTime(System.currentTimeMillis() + 250L);
            sender.send(message);
            Queue dlq = this.getProxyToQueue(this.getDeadLetterAddress());
            AmqpExpiredMessageTest.assertTrue((String)"Message not movied to DLQ", (boolean)Wait.waitFor(() -> dlq.getMessageCount() > 0L, (long)7000L, (long)500L));
            connection.close();
            if (restartServer) {
                this.server.stop();
                this.server.start();
            }
            connection = client.connect();
            session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(this.getDeadLetterAddress());
            receiver.flow(20);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpExpiredMessageTest.assertNotNull((Object)message);
            AmqpExpiredMessageTest.assertEquals((Object)this.getQueueName(), (Object)message.getMessageAnnotation("x-opt-ORIG-QUEUE"));
            AmqpExpiredMessageTest.assertNull((Object)message.getDeliveryAnnotation("shouldDisappear"));
            AmqpExpiredMessageTest.assertNull((Object)receiver.receiveNoWait());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDLQdMessageCanBeRedeliveredMultipleTimes() throws Throwable {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            AmqpMessage message = new AmqpMessage();
            message.setDurable(true);
            message.setTimeToLive(250L);
            message.setText("Test-Message");
            message.setMessageId(UUID.randomUUID().toString());
            message.setApplicationProperty("key", (Object)"value");
            sender.send(message);
            Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
            AmqpExpiredMessageTest.assertTrue((String)"Message not movied to DLQ", (boolean)Wait.waitFor(() -> dlqView.getMessageCount() > 0L, (long)7000L, (long)200L));
            AmqpReceiver receiver = session.createReceiver(this.getDeadLetterAddress());
            receiver.flow(20);
            message = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpExpiredMessageTest.assertNotNull((Object)message);
            AmqpExpiredMessageTest.assertEquals((long)0L, (long)message.getWrappedMessage().getDeliveryCount());
            message.modified(Boolean.valueOf(true), Boolean.valueOf(false));
            message = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpExpiredMessageTest.assertNotNull((Object)message);
            AmqpExpiredMessageTest.assertEquals((long)1L, (long)message.getWrappedMessage().getDeliveryCount());
            message.modified(Boolean.valueOf(true), Boolean.valueOf(false));
            message = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpExpiredMessageTest.assertNotNull((Object)message);
            AmqpExpiredMessageTest.assertEquals((long)2L, (long)message.getWrappedMessage().getDeliveryCount());
            message.modified(Boolean.valueOf(true), Boolean.valueOf(false));
            message = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpExpiredMessageTest.assertNotNull((Object)message);
            AmqpExpiredMessageTest.assertEquals((long)3L, (long)message.getWrappedMessage().getDeliveryCount());
        }
    }

    @Test(timeout=60000L)
    public void testExpireThorughAddressSettings() throws Exception {
        this.testExpireThorughAddressSettings(false);
    }

    @Test(timeout=60000L)
    public void testExpireThorughAddressSettingsRebootServer() throws Exception {
        this.testExpireThorughAddressSettings(true);
    }

    private void testExpireThorughAddressSettings(boolean reboot) throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.toSimpleString((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.toSimpleString((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryDelay(Long.valueOf(1000L));
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setDurable(true);
        message.setApplicationProperty("key1", (Object)"Value1");
        sender.send(message);
        message = new AmqpMessage();
        message.setBytes(new byte[512000]);
        message.setDurable(true);
        sender.send(message);
        sender.close();
        connection.close();
        if (reboot) {
            this.server.stop();
            this.server.getConfiguration().setMessageExpiryScanPeriod(100L);
            this.server.start();
        }
        Queue dlqView = this.getProxyToQueue(this.getDeadLetterAddress());
        Wait.assertEquals((long)2L, () -> ((Queue)dlqView).getMessageCount());
    }

    @Test
    public void testPreserveExpirationOnTTL() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.toSimpleString((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.toSimpleString((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryDelay(Long.valueOf(1000L));
        this.server.getAddressSettingsRepository().clear();
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        AmqpExpiredMessageTest.assertNotNull((Object)queueView);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setDurable(true);
        message.setTimeToLive(3600000L);
        message.setApplicationProperty("id", (Object)"0");
        sender.send(message);
        message = new AmqpMessage();
        message.setBytes(new byte[512000]);
        message.setDurable(true);
        message.setTimeToLive(3600000L);
        message.setApplicationProperty("id", (Object)"1");
        sender.send(message);
        Wait.assertEquals((long)2L, () -> ((Queue)queueView).getMessageCount());
        LinkedListIterator linkedListIterator = queueView.iterator();
        HashMap<String, Long> dataSet = new HashMap<String, Long>();
        int count = 0;
        while (linkedListIterator.hasNext()) {
            ++count;
            MessageReference ref = (MessageReference)linkedListIterator.next();
            String idUsed = ref.getMessage().getStringProperty("id");
            dataSet.put(idUsed, ref.getMessage().getExpiration());
        }
        Assert.assertEquals((long)2L, (long)count);
        linkedListIterator.close();
        this.server.stop();
        Thread.sleep(500L);
        this.server.getConfiguration().setMessageExpiryScanPeriod(100L);
        this.server.start();
        Queue queueViewAfterRestart = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)2L, () -> ((Queue)queueViewAfterRestart).getMessageCount());
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        linkedListIterator = queueViewAfterRestart.iterator();
        count = 0;
        while (linkedListIterator.hasNext()) {
            ++count;
            MessageReference ref = (MessageReference)linkedListIterator.next();
            String idUsed = ref.getMessage().getStringProperty("id");
            long originalExpiration = (Long)dataSet.get(idUsed);
            System.out.println("original Expiration = " + originalExpiration + " while this expiration = " + ref.getMessage().getExpiration());
            Assert.assertEquals((long)originalExpiration, (long)ref.getMessage().getExpiration());
        }
        Assert.assertEquals((long)2L, (long)count);
        linkedListIterator.close();
    }
}

