/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpConnectionListener;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.engine.Connection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AmqpBrokerRequestedHearbeatsTest
extends AmqpClientTestSupport {
    private final int TEST_IDLE_TIMEOUT = 1000;
    @Parameterized.Parameter(value=0)
    public boolean useOverride;

    @Parameterized.Parameters(name="useOverride={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        if (!this.useOverride) {
            params.put("amqpIdleTimeout", "1000");
        }
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setConnectionTtlCheckInterval(333L);
        if (this.useOverride) {
            server.getConfiguration().setConnectionTTLOverride(1000L);
        }
    }

    @Test(timeout=60000L)
    public void testBrokerSendsHalfConfiguredIdleTimeout() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Connection connection) {
                Assert.assertEquals((String)"Broker did not send half the idle timeout", (long)500L, (long)connection.getTransport().getRemoteIdleTimeout());
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)connection);
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testBrokerSendsHalfConfiguredIdleTimeoutWhenClientSendsTimeout() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Connection connection) {
                Assert.assertEquals((String)"Broker did not send half the idle timeout", (long)500L, (long)connection.getTransport().getRemoteIdleTimeout());
            }
        });
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setIdleTimeout(4000);
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)connection);
        connection.connect();
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testClientWithoutHeartbeatsGetsDropped() throws Exception {
        final CountDownLatch disconnected = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient();
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)client);
        AmqpConnection connection = this.addConnection(client.createConnection());
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)connection);
        connection.setIdleProcessingDisabled(true);
        connection.setListener(new AmqpConnectionListener(){

            public void onException(Throwable ex) {
                disconnected.countDown();
            }
        });
        connection.connect();
        AmqpBrokerRequestedHearbeatsTest.assertEquals((long)1L, (long)this.server.getConnectionCount());
        AmqpBrokerRequestedHearbeatsTest.assertTrue((boolean)disconnected.await(30L, TimeUnit.SECONDS));
        connection.close();
        Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
    }

    @Test(timeout=60000L)
    public void testClientWithHeartbeatsStaysAlive() throws Exception {
        final CountDownLatch disconnected = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient();
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)client);
        AmqpConnection connection = this.addConnection(client.createConnection());
        AmqpBrokerRequestedHearbeatsTest.assertNotNull((Object)connection);
        connection.setListener(new AmqpConnectionListener(){

            public void onException(Throwable ex) {
                disconnected.countDown();
            }
        });
        connection.connect();
        AmqpBrokerRequestedHearbeatsTest.assertEquals((long)1L, (long)this.server.getConnectionCount());
        AmqpBrokerRequestedHearbeatsTest.assertFalse((boolean)disconnected.await(5L, TimeUnit.SECONDS));
        connection.close();
        Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
    }
}

