/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class String64KLimitTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession session;
    private ServerLocator locator;
    private ClientSessionFactory sf;

    protected String genString(int len) {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(65 + i % 26);
        }
        return new String(chars);
    }

    @Test
    public void test64KLimitWithWriteString() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        String s1 = this.genString(16384);
        String s2 = this.genString(32768);
        String s3 = this.genString(65536);
        String s4 = this.genString(655360);
        ClientMessage tm1 = this.session.createMessage(false);
        tm1.getBodyBuffer().writeString(s1);
        ClientMessage tm2 = this.session.createMessage(false);
        tm2.getBodyBuffer().writeString(s2);
        ClientMessage tm3 = this.session.createMessage(false);
        tm3.getBodyBuffer().writeString(s3);
        ClientMessage tm4 = this.session.createMessage(false);
        tm4.getBodyBuffer().writeString(s4);
        producer.send((Message)tm1);
        producer.send((Message)tm2);
        producer.send((Message)tm3);
        producer.send((Message)tm4);
        ClientMessage rm1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)rm1);
        Assert.assertEquals((Object)s1, (Object)rm1.getBodyBuffer().readString());
        ClientMessage rm2 = consumer.receive(1000L);
        Assert.assertNotNull((Object)rm2);
        Assert.assertEquals((Object)s2, (Object)rm2.getBodyBuffer().readString());
        ClientMessage rm3 = consumer.receive(1000L);
        Assert.assertEquals((Object)s3, (Object)rm3.getBodyBuffer().readString());
        Assert.assertNotNull((Object)rm3);
        ClientMessage rm4 = consumer.receive(1000L);
        Assert.assertEquals((Object)s4, (Object)rm4.getBodyBuffer().readString());
        Assert.assertNotNull((Object)rm4);
    }

    @Test
    public void test64KLimitWithWriteUTF() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientConsumer consumer = this.session.createConsumer(queue);
        this.session.start();
        String s1 = this.genString(16384);
        String s2 = this.genString(32768);
        String s3 = this.genString(65536);
        String s4 = this.genString(655360);
        ClientMessage tm1 = this.session.createMessage(false);
        tm1.getBodyBuffer().writeUTF(s1);
        ClientMessage tm2 = this.session.createMessage(false);
        tm2.getBodyBuffer().writeUTF(s2);
        try {
            ClientMessage tm3 = this.session.createMessage(false);
            tm3.getBodyBuffer().writeUTF(s3);
            Assert.fail((String)"can not write UTF string bigger than 64K");
        }
        catch (Exception tm3) {
            // empty catch block
        }
        try {
            ClientMessage tm4 = this.session.createMessage(false);
            tm4.getBodyBuffer().writeUTF(s4);
            Assert.fail((String)"can not write UTF string bigger than 64K");
        }
        catch (Exception tm4) {
            // empty catch block
        }
        producer.send((Message)tm1);
        producer.send((Message)tm2);
        ClientMessage rm1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)rm1);
        ClientMessage rm2 = consumer.receive(1000L);
        Assert.assertNotNull((Object)rm2);
        Assert.assertEquals((Object)s1, (Object)rm1.getBodyBuffer().readUTF());
        Assert.assertEquals((Object)s2, (Object)rm2.getBodyBuffer().readUTF());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession();
    }
}

