/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class ByteArrayGuardAESCTR {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final int KEY_LENGTH = 128;
    private static final int IV_LENGTH = 16;
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_CODE = "AES/CTR/NoPadding";
    private SecretKey sk;
    private Charset utf8;

    public ByteArrayGuardAESCTR() {
        try {
            this.setupKeyAndCharset();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", e);
            }
            System.err.println("ERROR: Initializing Ciphers");
        }
    }

    public String encrypt(String value) {
        String securedata = null;
        byte[] bytes = value.getBytes(this.utf8);
        try {
            SecureRandom rand = new SecureRandom();
            byte[] iv = new byte[16];
            rand.nextBytes(iv);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            Cipher encryptCipher = Cipher.getInstance(CIPHER_CODE);
            encryptCipher.init(1, (Key)this.sk, ivspec);
            byte[] encdata = encryptCipher.doFinal(bytes);
            byte[] temp = ByteArrayGuardAESCTR.concatBytes(iv, encdata);
            securedata = Base64.getEncoder().encodeToString(temp);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", e);
            }
            return null;
        }
        return securedata;
    }

    public String decrypt(String value) throws InvalidKeyException {
        byte[] bytes = Base64.getDecoder().decode(value);
        try {
            byte[] plaindata;
            byte[] iv = new byte[16];
            if (bytes.length < iv.length) {
                throw new InvalidKeyException("Invalid characters in decrypted value");
            }
            System.arraycopy(bytes, 0, iv, 0, iv.length);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            Cipher decryptCipher = Cipher.getInstance(CIPHER_CODE);
            decryptCipher.init(2, (Key)this.sk, ivspec);
            byte[] encBytes = new byte[bytes.length - 16];
            System.arraycopy(bytes, 16, encBytes, 0, encBytes.length);
            for (byte cur : plaindata = decryptCipher.doFinal(encBytes)) {
                if (cur >= 0 && cur <= 127) continue;
                throw new InvalidKeyException("Invalid characters in decrypted value");
            }
            return new String(plaindata, this.utf8);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException nsae) {
            throw new InvalidKeyException(nsae);
        }
    }

    private void setupKeyAndCharset() {
        SortedMap<String, Charset> availableCharsets;
        try {
            InitialContext context = new InitialContext();
            String encodedKeyArray = (String)context.lookup("java:comp/env/faces/FlashSecretKey");
            if (null != encodedKeyArray) {
                byte[] keyArray = Base64.getDecoder().decode(encodedKeyArray);
                if (keyArray.length < 16) {
                    throw new FacesException("key must be at least 16 bytes long.");
                }
                this.sk = new SecretKeySpec(keyArray, KEY_ALGORITHM);
            }
        }
        catch (NamingException exception) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Unable to find the encoded key.", exception);
            }
        }
        catch (FacesException e) {
            throw new FacesException((Throwable)e);
        }
        if (null == this.sk) {
            try {
                KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
                kg.init(128);
                this.sk = kg.generateKey();
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        if ((availableCharsets = Charset.availableCharsets()).containsKey("UTF-8")) {
            this.utf8 = (Charset)availableCharsets.get("UTF-8");
        } else if (availableCharsets.containsKey("UTF8")) {
            this.utf8 = (Charset)availableCharsets.get("UTF8");
        } else {
            throw new FacesException("Unable to get UTF-8 Charset.");
        }
    }

    private static byte[] concatBytes(byte[] array1, byte[] array2) {
        byte[] cBytes = new byte[array1.length + array2.length];
        try {
            System.arraycopy(array1, 0, cBytes, 0, array1.length);
            System.arraycopy(array2, 0, cBytes, array1.length, array2.length);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return cBytes;
    }
}

