/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.SloppyMath;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.GeoPointDistanceCollector;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneDistanceToFieldProjection<E, P>
extends AbstractLuceneProjection<E, P>
implements CollectorFactory<GeoPointDistanceCollector> {
    private static final ProjectionConverter<Double, Double> NO_OP_DOUBLE_CONVERTER = new ProjectionConverter(Double.class, (value, context) -> value);
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final boolean multiValued;
    private final LuceneFieldCodec<GeoPoint> codec;
    private final GeoPoint center;
    private final DistanceUnit unit;
    private final ProjectionAccumulator<Double, Double, E, P> accumulator;
    private final DistanceCollectorKey collectorKey;

    private LuceneDistanceToFieldProjection(Builder builder, boolean multiValued, ProjectionAccumulator<Double, Double, E, P> accumulator) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.nestedDocumentPath = builder.field.nestedDocumentPath();
        this.multiValued = multiValued;
        this.codec = builder.codec;
        this.center = builder.center;
        this.unit = builder.unit;
        this.accumulator = accumulator;
        this.collectorKey = new DistanceCollectorKey(this.absoluteFieldPath, this.center);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append(", center=").append(this.center).append(", accumulator=").append(this.accumulator).append("]");
        return sb.toString();
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        if (this.multiValued) {
            context.requireStoredField(this.absoluteFieldPath, this.nestedDocumentPath);
        } else {
            context.requireCollector(this);
        }
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        Object accumulated = this.accumulator.createInitial();
        if (this.multiValued) {
            for (IndexableField field : documentResult.getDocument().getFields()) {
                if (!field.name().equals(this.absoluteFieldPath)) continue;
                GeoPoint decoded = this.codec.decode(field);
                double distanceInMeters = SloppyMath.haversinMeters((double)this.center.latitude(), (double)this.center.longitude(), (double)decoded.latitude(), (double)decoded.longitude());
                double distance = this.unit.fromMeters(Double.valueOf(distanceInMeters));
                accumulated = this.accumulator.accumulate(accumulated, (Object)distance);
            }
        } else {
            GeoPointDistanceCollector distanceCollector = context.getCollector(this.collectorKey);
            Double distanceOrNull = distanceCollector.getDistance(documentResult.getDocId());
            if (distanceOrNull != null) {
                accumulated = this.accumulator.accumulate(accumulated, (Object)this.unit.fromMeters(distanceOrNull));
            }
        }
        return (E)accumulated;
    }

    @Override
    public P transform(LoadingResult<?, ?> loadingResult, E extractedData, SearchProjectionTransformContext context) {
        FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
        return (P)this.accumulator.finish(extractedData, NO_OP_DOUBLE_CONVERTER, convertContext);
    }

    @Override
    public GeoPointDistanceCollector createCollector(CollectorExecutionContext context) {
        return new GeoPointDistanceCollector(this.absoluteFieldPath, this.nestedDocumentPath == null ? null : context.createNestedDocsProvider(this.nestedDocumentPath), this.center, context.getMaxDocs());
    }

    @Override
    public CollectorKey<GeoPointDistanceCollector> getCollectorKey() {
        return this.collectorKey;
    }

    public static class Builder
    extends AbstractLuceneProjection.AbstractBuilder<Double>
    implements DistanceToFieldProjectionBuilder {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private final LuceneFieldCodec<GeoPoint> codec;
        private final LuceneSearchIndexValueFieldContext<GeoPoint> field;
        private GeoPoint center;
        private DistanceUnit unit = DistanceUnit.METERS;

        private Builder(LuceneFieldCodec<GeoPoint> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope);
            this.codec = codec;
            this.field = field;
        }

        public void center(GeoPoint center) {
            this.center = center;
        }

        public void unit(DistanceUnit unit) {
            this.unit = unit;
        }

        public <P> SearchProjection<P> build(ProjectionAccumulator.Provider<Double, P> accumulatorProvider) {
            if (accumulatorProvider.isSingleValued() && this.field.multiValuedInRoot()) {
                throw log.invalidSingleValuedProjectionOnMultiValuedField(this.field.absolutePath(), this.field.eventContext());
            }
            return new LuceneDistanceToFieldProjection(this, !accumulatorProvider.isSingleValued(), accumulatorProvider.get());
        }
    }

    public static class Factory
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<DistanceToFieldProjectionBuilder, GeoPoint, LuceneFieldCodec<GeoPoint>> {
        public Factory(LuceneFieldCodec<GeoPoint> codec) {
            super(codec);
        }

        @Override
        public Builder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            field.nestedPathHierarchy();
            return new Builder(this.codec, scope, field);
        }
    }

    private static final class DistanceCollectorKey
    implements CollectorKey<GeoPointDistanceCollector> {
        private final String absoluteFieldPath;
        private final GeoPoint center;

        private DistanceCollectorKey(String absoluteFieldPath, GeoPoint center) {
            this.absoluteFieldPath = absoluteFieldPath;
            this.center = center;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            DistanceCollectorKey other = (DistanceCollectorKey)obj;
            return this.absoluteFieldPath.equals(other.absoluteFieldPath) && this.center.equals(other.center);
        }

        public int hashCode() {
            return Objects.hash(this.absoluteFieldPath, this.center);
        }
    }
}

