/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.lang.reflect.Constructor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.weld.deployment.PropertyReplacingBeansXmlParser;
import org.jboss.logging.Logger;
import org.jboss.weld.xml.BeansXmlParser;

final class BeansXmlParserFactory {
    private static final Logger log = Logger.getLogger((String)BeansXmlParserFactory.class.getPackage().getName());
    private static final Constructor<? extends BeansXmlParser> constructor;

    BeansXmlParserFactory() {
    }

    static BeansXmlParser getPropertyReplacingParser(DeploymentUnit deploymentUnit, boolean legacyBeansXmlTreatment) throws DeploymentUnitProcessingException {
        if (constructor == null) {
            return new PropertyReplacingBeansXmlParser(deploymentUnit);
        }
        try {
            return constructor.newInstance(deploymentUnit, legacyBeansXmlTreatment);
        }
        catch (ReflectiveOperationException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    static {
        String cname = PropertyReplacingBeansXmlParser.class.getPackage().getName() + ".AlternativePropertyReplacingBeansXmlParser";
        Constructor<?> ctor = null;
        try {
            Class<?> clazz = BeansXmlParserFactory.class.getClassLoader().loadClass(cname);
            ctor = clazz.getDeclaredConstructor(DeploymentUnit.class, Boolean.TYPE);
            log.debugf("Found constructor for %s", (Object)cname);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            log.debugf((Throwable)e, "Cannot find constructor for %s", (Object)cname);
        }
        constructor = ctor;
    }
}

