/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.stub;

import com.arjuna.schemas.ws._2005._10.wsarjtx.NotificationType;
import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.client.TerminationCoordinatorClient;
import com.arjuna.webservices11.wsarjtx.processors.TerminationParticipantCallback;
import com.arjuna.webservices11.wsarjtx.processors.TerminationParticipantProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.BusinessActivityTerminator;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.namespace.QName;
import org.jboss.ws.api.addressing.MAP;

public class BusinessActivityTerminatorStub
implements BusinessActivityTerminator {
    private W3CEndpointReference _terminationCoordinator = null;
    private final String _id;

    public BusinessActivityTerminatorStub(String id, W3CEndpointReference terminationCoordinator) throws Exception {
        this._terminationCoordinator = terminationCoordinator;
        this._id = id;
    }

    @Override
    public void close() throws TransactionRolledBackException, UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        RequestCallback callback = new RequestCallback();
        TerminationParticipantProcessor terminationParticipantProcessor = TerminationParticipantProcessor.getProcessor();
        terminationParticipantProcessor.registerCallback(this._id, callback);
        try {
            TerminationCoordinatorClient.getClient().sendClose(this._terminationCoordinator, map, new InstanceIdentifier(this._id));
            callback.waitUntilTriggered();
        }
        catch (Throwable th) {
            throw new SystemException();
        }
        finally {
            terminationParticipantProcessor.removeCallback(this._id);
        }
        if (callback.hasTriggered()) {
            if (callback.receivedClosed()) {
                return;
            }
            SoapFault soapFault = callback.getSoapFault();
            if (soapFault != null) {
                QName subcode = soapFault.getSubcode();
                if (ArjunaTXConstants.TRANSACTIONROLLEDBACK_ERROR_CODE_QNAME.equals(subcode)) {
                    throw new TransactionRolledBackException();
                }
                if (ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(subcode)) {
                    throw new UnknownTransactionException();
                }
            }
        }
        throw new SystemException();
    }

    @Override
    public void cancel() throws FaultedException, UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        RequestCallback callback = new RequestCallback();
        TerminationParticipantProcessor terminationParticipantProcessor = TerminationParticipantProcessor.getProcessor();
        terminationParticipantProcessor.registerCallback(this._id, callback);
        try {
            TerminationCoordinatorClient.getClient().sendCancel(this._terminationCoordinator, map, new InstanceIdentifier(this._id));
            callback.waitUntilTriggered();
        }
        catch (Throwable th) {
            throw new SystemException();
        }
        finally {
            terminationParticipantProcessor.removeCallback(this._id);
        }
        if (callback.hasTriggered()) {
            QName subcode;
            if (callback.receivedCancelled()) {
                return;
            }
            if (callback.receivedFaulted()) {
                throw new FaultedException();
            }
            SoapFault soapFault = callback.getSoapFault();
            if (soapFault != null && ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(subcode = soapFault.getSubcode())) {
                throw new UnknownTransactionException();
            }
        }
        throw new SystemException();
    }

    @Override
    public void complete() throws FaultedException, UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        RequestCallback callback = new RequestCallback();
        TerminationParticipantProcessor terminationParticipantProcessor = TerminationParticipantProcessor.getProcessor();
        terminationParticipantProcessor.registerCallback(this._id, callback);
        try {
            TerminationCoordinatorClient.getClient().sendComplete(this._terminationCoordinator, map, new InstanceIdentifier(this._id));
            callback.waitUntilTriggered();
        }
        catch (Throwable th) {
            throw new SystemException();
        }
        finally {
            terminationParticipantProcessor.removeCallback(this._id);
        }
        if (callback.hasTriggered()) {
            QName subcode;
            if (callback.receivedCompleted()) {
                return;
            }
            if (callback.receivedFaulted()) {
                throw new FaultedException();
            }
            SoapFault soapFault = callback.getSoapFault();
            if (soapFault != null && ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(subcode = soapFault.getSubcode())) {
                throw new UnknownTransactionException();
            }
        }
        throw new SystemException();
    }

    @Override
    public W3CEndpointReference getEndpoint() {
        return this._terminationCoordinator;
    }

    public void unknown() throws SystemException {
        this.error();
    }

    public void error() throws SystemException {
    }

    private static class RequestCallback
    extends TerminationParticipantCallback {
        private MAP map;
        private ArjunaContext arjunaContext;
        private SoapFault soapFault;
        private boolean completed;
        private boolean cancelled;
        private boolean closed;
        private boolean faulted;

        private RequestCallback() {
        }

        MAP getAddressingProperties() {
            return this.map;
        }

        ArjunaContext getArjunaContextWS() {
            return this.arjunaContext;
        }

        SoapFault getSoapFault() {
            return this.soapFault;
        }

        boolean receivedCompleted() {
            return this.completed;
        }

        boolean receivedCancelled() {
            return this.cancelled;
        }

        boolean receivedClosed() {
            return this.closed;
        }

        boolean receivedFaulted() {
            return this.faulted;
        }

        @Override
        public void completed(NotificationType completed, MAP map, ArjunaContext arjunaContext) {
            this.completed = true;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }

        @Override
        public void cancelled(NotificationType cancelled, MAP map, ArjunaContext arjunaContext) {
            this.cancelled = true;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }

        @Override
        public void closed(NotificationType closed, MAP map, ArjunaContext arjunaContext) {
            this.closed = true;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }

        @Override
        public void faulted(NotificationType faulted, MAP map, ArjunaContext arjunaContext) {
            this.faulted = true;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }

        @Override
        public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
            this.soapFault = soapFault;
            this.map = map;
            this.arjunaContext = arjunaContext;
        }
    }
}

