/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ejb.infinispan.timer.CompositeImmutableTimerMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.CompositeTimerMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.TimerAccessMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.TimerAccessMetaDataEntry;
import org.wildfly.clustering.ejb.infinispan.timer.TimerAccessMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCreationMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCreationMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.TimerIndex;
import org.wildfly.clustering.ejb.infinispan.timer.TimerIndexKey;
import org.wildfly.clustering.ejb.infinispan.timer.TimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerMetaData;

public class InfinispanTimerMetaDataFactory<I, V>
implements TimerMetaDataFactory<I, V> {
    private final Cache<TimerIndexKey, I> indexCache;
    private final Cache<TimerCreationMetaDataKey<I>, TimerCreationMetaData<V>> creationMetaDataReadCache;
    private final Cache<TimerCreationMetaDataKey<I>, TimerCreationMetaData<V>> creationMetaDataWriteCache;
    private final Cache<TimerAccessMetaDataKey<I>, Duration> accessMetaDataCache;
    private final TimerMetaDataConfiguration<V> config;

    public InfinispanTimerMetaDataFactory(TimerMetaDataConfiguration<V> config) {
        this.config = config;
        this.indexCache = config.getCache();
        this.creationMetaDataReadCache = config.getReadForUpdateCache();
        this.creationMetaDataWriteCache = config.getSilentWriteCache();
        this.accessMetaDataCache = config.getSilentWriteCache();
    }

    public Map.Entry<TimerCreationMetaData<V>, TimerAccessMetaData> createValue(I id, Map.Entry<TimerCreationMetaData<V>, TimerIndex> entry) {
        TimerCreationMetaData<V> creationMetaData = entry.getKey();
        TimerIndex index = entry.getValue();
        if (index != null && this.indexCache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).putIfAbsent((Object)new TimerIndexKey(index), id) != null) {
            return null;
        }
        this.creationMetaDataWriteCache.put(new TimerCreationMetaDataKey<I>(id), creationMetaData);
        TimerAccessMetaDataEntry<I> accessMetaData = new TimerAccessMetaDataEntry<I>(this.accessMetaDataCache, new TimerAccessMetaDataKey<I>(id));
        return new AbstractMap.SimpleImmutableEntry<TimerCreationMetaData<V>, TimerAccessMetaData>(creationMetaData, accessMetaData);
    }

    public Map.Entry<TimerCreationMetaData<V>, TimerAccessMetaData> findValue(I id) {
        TimerCreationMetaData creationMetaData = (TimerCreationMetaData)this.creationMetaDataReadCache.get(new TimerCreationMetaDataKey<I>(id));
        return creationMetaData != null ? new AbstractMap.SimpleImmutableEntry<TimerCreationMetaData, TimerAccessMetaDataEntry<I>>(creationMetaData, new TimerAccessMetaDataEntry<I>(this.accessMetaDataCache, new TimerAccessMetaDataKey<I>(id))) : null;
    }

    public boolean remove(I id) {
        TimerCreationMetaDataKey<I> key = new TimerCreationMetaDataKey<I>(id);
        TimerCreationMetaData creationMetaData = (TimerCreationMetaData)this.creationMetaDataReadCache.get(key);
        if (creationMetaData != null) {
            this.accessMetaDataCache.remove(new TimerAccessMetaDataKey<I>(id));
            this.creationMetaDataWriteCache.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public TimerMetaData createTimerMetaData(I id, Map.Entry<TimerCreationMetaData<V>, TimerAccessMetaData> entry) {
        return new CompositeTimerMetaData<V>(this.config, entry.getKey(), entry.getValue());
    }

    @Override
    public ImmutableTimerMetaData createImmutableTimerMetaData(Map.Entry<TimerCreationMetaData<V>, TimerAccessMetaData> entry) {
        return new CompositeImmutableTimerMetaData<V>(this.config, entry.getKey(), entry.getValue());
    }
}

