/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorOriginalTypeNode<T>
extends PojoIndexingProcessor<T> {
    private final Iterable<IndexObjectFieldReference> parentIndexObjectReferences;
    private final PojoIndexingProcessor<? super T> nested;
    private final boolean isEntityType;

    public PojoIndexingProcessorOriginalTypeNode(Iterable<IndexObjectFieldReference> parentIndexObjectReferences, PojoIndexingProcessor<? super T> nested, boolean isEntityType) {
        this.parentIndexObjectReferences = parentIndexObjectReferences;
        this.nested = nested;
        this.isEntityType = isEntityType;
    }

    @Override
    public void close() {
        this.nested.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process type");
        builder.attribute("objectFieldsToCreate", this.parentIndexObjectReferences);
        builder.attribute("nested", this.nested);
        builder.attribute("isEntityType", (Object)this.isEntityType);
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorRootContext context) {
        if (source == null) {
            return;
        }
        source = context.sessionContext().runtimeIntrospector().unproxy(source);
        if (this.isEntityType && context.isDeleted(source)) {
            return;
        }
        DocumentElement parentObject = target;
        for (IndexObjectFieldReference objectFieldReference : this.parentIndexObjectReferences) {
            parentObject = parentObject.addObject(objectFieldReference);
        }
        this.nested.process(parentObject, source, context);
    }
}

