/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.util.Collection;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorMultiNode;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

abstract class AbstractPojoProcessorNodeBuilder {
    final PojoMappingHelper mappingHelper;
    final IndexBindingContext bindingContext;

    AbstractPojoProcessorNodeBuilder(PojoMappingHelper mappingHelper, IndexBindingContext bindingContext) {
        this.mappingHelper = mappingHelper;
        this.bindingContext = bindingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getModelPath() + "]";
    }

    abstract BoundPojoModelPath getModelPath();

    abstract void closeOnFailure();

    public final ContextualFailureCollector failureCollector() {
        BoundPojoModelPath modelPath = this.getModelPath();
        ContextualFailureCollector failureCollector = this.mappingHelper.failureCollector().withContext(PojoEventContexts.fromType(modelPath.getRootType().rawType()));
        PojoModelPath unboundPath = modelPath.toUnboundPath();
        if (unboundPath != null) {
            failureCollector = failureCollector.withContext(PojoEventContexts.fromPath(modelPath.toUnboundPath()));
        }
        return failureCollector;
    }

    protected final <T> PojoIndexingProcessor<? super T> createNested(Collection<? extends PojoIndexingProcessor<? super T>> elements) {
        int size = elements.size();
        if (size == 0) {
            return PojoIndexingProcessor.noOp();
        }
        if (size == 1) {
            return elements.iterator().next();
        }
        return new PojoIndexingProcessorMultiNode(elements);
    }
}

