/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverImpl;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathWalker;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathFilterProvider;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.AssertionFailure;

class PojoImplicitReindexingResolverBuilder<T> {
    private final PojoRawTypeModel<T> rawTypeModel;
    private final Set<PojoModelPathValueNode> dirtyPathsTriggeringSelfReindexing = new LinkedHashSet<PojoModelPathValueNode>();
    private final PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRootBuilder;
    private boolean frozen = false;

    static Walker walker() {
        return Walker.INSTANCE;
    }

    PojoImplicitReindexingResolverBuilder(PojoRawTypeModel<T> rawTypeModel, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this.rawTypeModel = rawTypeModel;
        this.containingEntitiesResolverRootBuilder = new PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T>(BoundPojoModelPath.root(rawTypeModel), buildingHelper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.rawTypeModel + "]";
    }

    void closeOnFailure() {
        this.containingEntitiesResolverRootBuilder.closeOnFailure();
    }

    void addDirtyPathTriggeringSelfReindexing(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        this.checkNotFrozen();
        this.dirtyPathsTriggeringSelfReindexing.add(dirtyPathFromEntityType.toUnboundPath());
    }

    PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRoot() {
        return this.containingEntitiesResolverRootBuilder;
    }

    final Optional<PojoImplicitReindexingResolver<T>> build(PojoPathFilterProvider pathFilterProvider) {
        this.freeze();
        Set<PojoModelPathValueNode> immutableDirtyPathsAcceptedByFilter = this.dirtyPathsTriggeringSelfReindexing;
        Optional<PojoImplicitReindexingResolverNode<PojoImplicitReindexingResolverNode>> containingEntitiesResolverRootOptional = this.containingEntitiesResolverRootBuilder.build(pathFilterProvider, null);
        if (immutableDirtyPathsAcceptedByFilter.isEmpty() && !containingEntitiesResolverRootOptional.isPresent()) {
            return Optional.empty();
        }
        PojoPathFilter dirtySelfFilter = pathFilterProvider.create(immutableDirtyPathsAcceptedByFilter);
        PojoImplicitReindexingResolverNode containingEntitiesResolverRoot = containingEntitiesResolverRootOptional.orElseGet(PojoImplicitReindexingResolverNode::noOp);
        HashSet<PojoModelPathValueNode> dirtySelfOrContainingPaths = new HashSet<PojoModelPathValueNode>(immutableDirtyPathsAcceptedByFilter);
        dirtySelfOrContainingPaths.addAll(this.containingEntitiesResolverRootBuilder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
        PojoPathFilter dirtySelfOrContainingFilter = pathFilterProvider.create(dirtySelfOrContainingPaths);
        return Optional.of(new PojoImplicitReindexingResolverImpl(dirtySelfFilter, dirtySelfOrContainingFilter, containingEntitiesResolverRoot));
    }

    private void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.containingEntitiesResolverRootBuilder.freeze();
        }
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new AssertionFailure("A mutating method was called on " + this + " after it was frozen.");
        }
    }

    static class Walker
    implements PojoModelPathWalker<AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?>, PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?>, PojoImplicitReindexingResolverValueNodeBuilderDelegate<?>> {
        public static final Walker INSTANCE = new Walker();

        Walker() {
        }

        @Override
        public PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> property(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> typeNode, String propertyName) {
            return typeNode.property(propertyName);
        }

        @Override
        public PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> value(PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> propertyNode, ContainerExtractorPath extractorPath) {
            return propertyNode.value(extractorPath);
        }

        @Override
        public AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> type(PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> valueNode) {
            return valueNode.type();
        }
    }
}

