/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.spec;

public enum CredentialInterfaceEnum {
    PasswordCredential("jakarta.resource.spi.security.PasswordCredential"),
    GSSCredential("org.ietf.jgss.GSSCredential"),
    GenericCredential("jakarta.resource.spi.security.GenericCredential");

    private final String fullQualifiedName;

    private CredentialInterfaceEnum(String name) {
        this.fullQualifiedName = name;
    }

    public static CredentialInterfaceEnum forName(String fullQualifiedName) throws IllegalArgumentException {
        if ("jakarta.resource.spi.security.PasswordCredential".equals(fullQualifiedName)) {
            return PasswordCredential;
        }
        if ("org.ietf.jgss.GSSCredential".equals(fullQualifiedName)) {
            return GSSCredential;
        }
        if ("jakarta.resource.spi.security.GenericCredential".equals(fullQualifiedName)) {
            return GenericCredential;
        }
        throw new IllegalArgumentException("fullQualifiedName should be one of jakarta.resource.spi.security.PasswordCredential; org.ietf.jgss.GSSCredential;jakarta.resource.spi.security.GenericCredential");
    }

    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public String toString() {
        return this.fullQualifiedName;
    }
}

