/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import io.undertow.predicate.Predicate;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.deployers.AllowWSRequestPredicate;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;

public class GracefulShutdownIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final AttachmentKey<Predicate> ATTACHMENT_KEY = AttachmentKey.create(Predicate.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        JAXWSDeployment wsDeployment = (JAXWSDeployment)unit.getAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        if (wsDeployment != null) {
            AllowWSRequestPredicate predicate = new AllowWSRequestPredicate();
            unit.putAttachment(ATTACHMENT_KEY, (Object)predicate);
            unit.addToAttachmentList(UndertowAttachments.ALLOW_REQUEST_WHEN_SUSPENDED, (Object)predicate);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        Predicate predicate = (Predicate)deploymentUnit.removeAttachment(ATTACHMENT_KEY);
        if (predicate != null) {
            deploymentUnit.getAttachmentList(UndertowAttachments.ALLOW_REQUEST_WHEN_SUSPENDED).remove(predicate);
        }
    }
}

