/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.jaxrs;

import io.smallrye.metrics.MetricRegistries;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Duration;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class JaxRsMetricsServletFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long start = System.nanoTime();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Throwable throwable) {
            MetricID metricID = (MetricID)servletRequest.getAttribute("smallrye.metrics.jaxrs.metricID");
            if (metricID != null) {
                this.createMetrics(metricID);
                if (!servletRequest.isAsyncStarted()) {
                    boolean success = servletRequest.getAttribute("smallrye.metrics.jaxrs.successful") != null;
                    this.update(success, start, metricID);
                } else {
                    servletRequest.getAsyncContext().addListener(new AsyncListener(start, metricID){
                        final /* synthetic */ long val$start;
                        final /* synthetic */ MetricID val$metricID;
                        {
                            this.val$start = l;
                            this.val$metricID = metricID;
                        }

                        public void onComplete(AsyncEvent event) {
                            boolean success = event.getSuppliedRequest().getAttribute("smallrye.metrics.jaxrs.successful") != null;
                            JaxRsMetricsServletFilter.this.update(success, this.val$start, this.val$metricID);
                        }

                        public void onTimeout(AsyncEvent event) {
                        }

                        public void onError(AsyncEvent event) {
                            boolean success = event.getSuppliedRequest().getAttribute("smallrye.metrics.jaxrs.successful") != null;
                            JaxRsMetricsServletFilter.this.update(success, this.val$start, this.val$metricID);
                        }

                        public void onStartAsync(AsyncEvent event) {
                        }
                    });
                }
            }
            throw throwable;
        }
        MetricID metricID = (MetricID)servletRequest.getAttribute("smallrye.metrics.jaxrs.metricID");
        if (metricID != null) {
            this.createMetrics(metricID);
            if (!servletRequest.isAsyncStarted()) {
                boolean success = servletRequest.getAttribute("smallrye.metrics.jaxrs.successful") != null;
                this.update(success, start, metricID);
            } else {
                servletRequest.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private void update(boolean success, long startTimestamp, MetricID metricID) {
        if (success) {
            this.updateAfterSuccess(startTimestamp, metricID);
        } else {
            this.updateAfterFailure(metricID);
        }
    }

    private void updateAfterSuccess(long startTimestamp, MetricID metricID) {
        long duration = System.nanoTime() - startTimestamp;
        MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.BASE);
        registry.getSimpleTimer(metricID).update(Duration.ofNanos(duration));
    }

    private void updateAfterFailure(MetricID metricID) {
        MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.BASE);
        registry.getCounter(this.transformToMetricIDForFailedRequest(metricID)).inc();
    }

    private MetricID transformToMetricIDForFailedRequest(MetricID metricID) {
        return new MetricID("REST.request.unmappedException.total", metricID.getTagsAsArray());
    }

    private void createMetrics(MetricID metricID) {
        MetricID metricIDForFailure;
        MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.BASE);
        if (registry.getSimpleTimer(metricID) == null) {
            Metadata successMetadata = Metadata.builder().withName(metricID.getName()).withDescription("The number of invocations and total response time of this RESTful resource method since the start of the server.").withUnit("nanoseconds").build();
            registry.simpleTimer(successMetadata, metricID.getTagsAsArray());
        }
        if (registry.getCounter(metricIDForFailure = this.transformToMetricIDForFailedRequest(metricID)) == null) {
            Metadata failureMetadata = Metadata.builder().withName(metricIDForFailure.getName()).withDisplayName("Total Unmapped Exceptions count").withDescription("The total number of unmapped exceptions that occurred from this RESTful resource method since the start of the server.").build();
            registry.counter(failureMetadata, metricIDForFailure.getTagsAsArray());
        }
    }

    public void destroy() {
    }
}

