/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.reactive.messaging.kafka.commit.ProcessingState;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.Logger;

public class StateStore<T> {
    protected KafkaLogging log = (KafkaLogging)Logger.getMessageLogger(KafkaLogging.class, (String)"io.smallrye.reactive.messaging.kafka");
    private final TopicPartition topicPartition;
    private final long recordOffset;
    private final Supplier<ProcessingState<T>> currentSupplier;
    private ProcessingState<T> next;
    private boolean persist;

    public static <S> ProcessingState<S> getProcessingState(Message<?> message) {
        return message.getMetadata(StateStore.class).flatMap(StateStore::getNext).orElse(null);
    }

    public static boolean isPersist(Message<?> message) {
        return message.getMetadata(StateStore.class).map(StateStore::isPersist).orElse(false);
    }

    public static <S> StateStore<S> fromMessage(Message<?> message) {
        return message.getMetadata(StateStore.class).orElse(null);
    }

    public StateStore(TopicPartition topicPartition, long recordOffset, Supplier<ProcessingState<T>> stateSupplier) {
        this.topicPartition = topicPartition;
        this.recordOffset = recordOffset;
        this.currentSupplier = stateSupplier;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }

    public boolean isPersist() {
        return this.persist;
    }

    public Optional<ProcessingState<T>> getCurrent() {
        return Optional.ofNullable(this.currentSupplier.get());
    }

    public Optional<ProcessingState<T>> getNext() {
        return Optional.ofNullable(this.next);
    }

    public T storeLocal(T state, long offset) {
        this.next = new ProcessingState<T>(state, offset);
        return this.next.getState();
    }

    public T storeLocal(T state) {
        return this.storeLocal(state, this.getRecordOffset() + 1L);
    }

    public T transformAndStoreLocal(T initialState, Function<T, T> transformation) {
        Optional<ProcessingState<ProcessingState<T>>> current = this.getCurrent();
        ProcessingState<T> processingState = current.orElse(new ProcessingState<T>(initialState, 0L));
        if (this.recordOffset >= processingState.getOffset()) {
            return this.storeLocal(transformation.apply(processingState.getState()));
        }
        this.log.debugf("Skipping transformation on %s:%d, latest processing state offset %d", this.topicPartition, this.recordOffset, processingState.getOffset());
        return processingState.getState();
    }

    public T storeOnAck(T state, long offset) {
        this.persist = true;
        return this.storeLocal(state, offset);
    }

    public T storeOnAck(T state) {
        return this.storeOnAck(state, this.getRecordOffset() + 1L);
    }

    public T transformAndStoreOnAck(T initialState, Function<T, T> transformation) {
        Optional<ProcessingState<ProcessingState<T>>> current = this.getCurrent();
        ProcessingState<T> processingState = current.orElse(new ProcessingState<T>(initialState, 0L));
        if (this.recordOffset >= processingState.getOffset()) {
            return this.storeOnAck(transformation.apply(processingState.getState()));
        }
        this.log.debugf("Skipping transformation on %s:%d, latest processing state offset %d", this.topicPartition, this.recordOffset, processingState.getOffset());
        return processingState.getState();
    }
}

