/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.format.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.types.format.impl.ElasticsearchDefaultFieldFormatProvider;
import org.hibernate.search.util.common.AssertionFailure;

public class Elasticsearch7DefaultFieldFormatProvider
implements ElasticsearchDefaultFieldFormatProvider {
    static final Map<Class<? extends TemporalAccessor>, String> JAVA_TIME_FORMAT_PATTERN_BY_TYPE;
    private final Map<Class<? extends TemporalAccessor>, DateTimeFormatter> dateTimeFormatters = new HashMap<Class<? extends TemporalAccessor>, DateTimeFormatter>();
    private final Map<Class<? extends TemporalAccessor>, List<String>> mappingFormats = new HashMap<Class<? extends TemporalAccessor>, List<String>>();

    public Elasticsearch7DefaultFieldFormatProvider() {
        for (Map.Entry<Class<? extends TemporalAccessor>, String> entry : JAVA_TIME_FORMAT_PATTERN_BY_TYPE.entrySet()) {
            Class<? extends TemporalAccessor> type = entry.getKey();
            String pattern = entry.getValue();
            this.dateTimeFormatters.put(type, DateTimeFormatter.ofPattern(pattern, Locale.ROOT));
            this.mappingFormats.put(type, Collections.singletonList(pattern));
        }
    }

    @Override
    public DateTimeFormatter getDefaultDateTimeFormatter(Class<? extends TemporalAccessor> fieldType) {
        DateTimeFormatter result = this.dateTimeFormatters.get(fieldType);
        if (result == null) {
            throw new AssertionFailure("Unknown date time formatter for " + fieldType);
        }
        return result;
    }

    @Override
    public List<String> getDefaultMappingFormat(Class<? extends TemporalAccessor> fieldType) {
        List<String> result = this.mappingFormats.get(fieldType);
        if (result == null) {
            throw new AssertionFailure("Unknown mapping format for " + fieldType);
        }
        return result;
    }

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(Instant.class, "uuuu-MM-dd'T'HH:mm:ss.SSSSSSSSSZZZZZ");
        map.put(LocalDate.class, "uuuu-MM-dd");
        map.put(LocalTime.class, "HH:mm:ss.SSSSSSSSS");
        map.put(LocalDateTime.class, "uuuu-MM-dd'T'HH:mm:ss.SSSSSSSSS");
        map.put(OffsetTime.class, "HH:mm:ss.SSSSSSSSSZZZZZ");
        map.put(OffsetDateTime.class, "uuuu-MM-dd'T'HH:mm:ss.SSSSSSSSSZZZZZ");
        map.put(ZonedDateTime.class, "uuuu-MM-dd'T'HH:mm:ss.SSSSSSSSSZZZZZ'['VV']'");
        map.put(Year.class, "uuuu");
        map.put(YearMonth.class, "uuuu-MM");
        map.put(MonthDay.class, "uuuu-MM-dd");
        JAVA_TIME_FORMAT_PATTERN_BY_TYPE = Collections.unmodifiableMap(map);
    }
}

