/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExistingIndexMetadata;

public class ElasticsearchSchemaCreatorImpl
implements ElasticsearchSchemaCreator {
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final IndexLayoutStrategy indexLayoutStrategy;

    public ElasticsearchSchemaCreatorImpl(ElasticsearchSchemaAccessor schemaAccessor, IndexLayoutStrategy indexLayoutStrategy) {
        this.schemaAccessor = schemaAccessor;
        this.indexLayoutStrategy = indexLayoutStrategy;
    }

    @Override
    public CompletableFuture<?> createIndexAssumeNonExisting(IndexNames indexNames, IndexMetadata indexMetadata) {
        return this.schemaAccessor.createIndexAssumeNonExisting(this.createPrimaryIndexName(indexNames), indexMetadata.getAliases(), indexMetadata.getSettings(), indexMetadata.getMapping());
    }

    @Override
    public CompletableFuture<ExistingIndexMetadata> createIndexIfAbsent(IndexNames indexNames, IndexMetadata indexMetadata) {
        return this.schemaAccessor.getCurrentIndexMetadataOrNull(indexNames).thenCompose(existingIndexMetadata -> {
            if (existingIndexMetadata != null) {
                return CompletableFuture.completedFuture(existingIndexMetadata);
            }
            return this.schemaAccessor.createIndexIgnoreExisting(this.createPrimaryIndexName(indexNames), indexMetadata.getAliases(), indexMetadata.getSettings(), indexMetadata.getMapping()).thenApply(ignored -> null);
        });
    }

    private URLEncodedString createPrimaryIndexName(IndexNames indexNames) {
        return IndexNames.encodeName(this.indexLayoutStrategy.createInitialElasticsearchIndexName(indexNames.hibernateSearchIndex()));
    }
}

