/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.mapping.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.IndexSchemaRootContributor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IndexNameTypeNameMapping
implements TypeNameMapping {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final TypeNameFromIndexNameExtractionHelper mappedTypeNameExtractionHelper;
    private final IndexLayoutStrategy indexLayoutStrategy;

    public IndexNameTypeNameMapping(IndexLayoutStrategy indexLayoutStrategy) {
        this.indexLayoutStrategy = indexLayoutStrategy;
        this.mappedTypeNameExtractionHelper = new TypeNameFromIndexNameExtractionHelper(indexLayoutStrategy);
    }

    @Override
    public Optional<IndexSchemaRootContributor> getIndexSchemaRootContributor() {
        return Optional.empty();
    }

    @Override
    public Optional<DocumentMetadataContributor> getDocumentMetadataContributor(String mappedTypeName) {
        return Optional.empty();
    }

    @Override
    public void register(IndexNames indexNames, String mappedTypeName) {
        String uniqueKey = IndexNames.normalizeName(this.indexLayoutStrategy.extractUniqueKeyFromHibernateSearchIndexName(indexNames.hibernateSearchIndex()));
        this.mappedTypeNameExtractionHelper.primaryIndexNameUniqueKeyToMappedTypeNames.put(uniqueKey, mappedTypeName);
    }

    @Override
    public ProjectionExtractionHelper<String> getTypeNameExtractionHelper() {
        return this.mappedTypeNameExtractionHelper;
    }

    private static final class TypeNameFromIndexNameExtractionHelper
    implements ProjectionExtractionHelper<String> {
        private static final JsonAccessor<String> HIT_INDEX_NAME_ACCESSOR = JsonAccessor.root().property("_index").asString();
        private final IndexLayoutStrategy indexLayoutStrategy;
        private final Map<String, String> primaryIndexNameUniqueKeyToMappedTypeNames = new ConcurrentHashMap<String, String>();

        public TypeNameFromIndexNameExtractionHelper(IndexLayoutStrategy indexLayoutStrategy) {
            this.indexLayoutStrategy = indexLayoutStrategy;
        }

        @Override
        public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        }

        @Override
        public String extract(JsonObject hit, SearchProjectionExtractContext context) {
            String mappedTypeName;
            String primaryIndexName = HIT_INDEX_NAME_ACCESSOR.get(hit).orElseThrow(log::elasticsearchResponseMissingData);
            try {
                String uniqueKey = this.indexLayoutStrategy.extractUniqueKeyFromElasticsearchIndexName(primaryIndexName);
                mappedTypeName = this.primaryIndexNameUniqueKeyToMappedTypeNames.get(uniqueKey);
                if (mappedTypeName == null) {
                    throw log.invalidIndexUniqueKey(uniqueKey, this.primaryIndexNameUniqueKeyToMappedTypeNames.keySet());
                }
            }
            catch (SearchException e) {
                throw log.elasticsearchResponseUnknownIndexName(primaryIndexName, e.getMessage(), (Exception)((Object)e));
            }
            return mappedTypeName;
        }
    }
}

