/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Immutable;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class SerializableJavaType<T extends Serializable>
extends AbstractClassJavaType<T> {
    public SerializableJavaType(Class<T> type) {
        this(type, SerializableJavaType.createMutabilityPlan(type));
    }

    public SerializableJavaType(Class<T> type, MutabilityPlan<T> mutabilityPlan) {
        super(type, mutabilityPlan == null ? SerializableJavaType.createMutabilityPlan(type) : mutabilityPlan);
    }

    private static <T> MutabilityPlan<T> createMutabilityPlan(Class<T> type) {
        if (type.isAnnotationPresent(Immutable.class)) {
            return ImmutableMutabilityPlan.instance();
        }
        return SerializableMutabilityPlan.INSTANCE;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        int typeCode = indicators.isLob() ? 2004 : -3;
        return indicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(typeCode);
    }

    @Override
    public String toString(T value) {
        return PrimitiveByteArrayJavaType.INSTANCE.toString(this.toBytes(value));
    }

    @Override
    public T fromString(CharSequence string) {
        return this.fromBytes(PrimitiveByteArrayJavaType.INSTANCE.fromString(string));
    }

    @Override
    public boolean areEqual(T one, T another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.equals(another) || Arrays.equals(this.toBytes(one), this.toBytes(another));
    }

    @Override
    public int extractHashCode(T value) {
        return PrimitiveByteArrayJavaType.INSTANCE.extractHashCode(this.toBytes(value));
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (X)this.toBytes(value);
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return (X)new ByteArrayInputStream(this.toBytes(value));
        }
        if (BinaryStream.class.isAssignableFrom(type)) {
            return (X)new BinaryStreamImpl(this.toBytes(value));
        }
        if (Blob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createBlob(this.toBytes(value));
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return this.fromBytes((byte[])value);
        }
        if (value instanceof InputStream) {
            return this.fromBytes(DataHelper.extractBytes((InputStream)value));
        }
        if (value instanceof Blob) {
            try {
                return this.fromBytes(DataHelper.extractBytes(((Blob)value).getBinaryStream()));
            }
            catch (SQLException e) {
                throw new HibernateException(e);
            }
        }
        if (this.getJavaTypeClass().isInstance(value)) {
            return (T)((Serializable)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    protected byte[] toBytes(T value) {
        return SerializationHelper.serialize(value);
    }

    protected T fromBytes(byte[] bytes) {
        return (T)((Serializable)SerializationHelper.deserialize(bytes, this.getJavaTypeClass().getClassLoader()));
    }

    public static class SerializableMutabilityPlan<S extends Serializable>
    extends MutableMutabilityPlan<S> {
        public static final SerializableMutabilityPlan<Serializable> INSTANCE = new SerializableMutabilityPlan();

        private SerializableMutabilityPlan() {
        }

        @Override
        public S deepCopyNotNull(S value) {
            return (S)((Serializable)SerializationHelper.clone(value));
        }
    }
}

