/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitFetchBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderDiscriminatedAssociation
implements ImplicitFetchBuilder {
    private final NavigablePath fetchPath;
    private final DiscriminatedAssociationAttributeMapping fetchable;

    public ImplicitFetchBuilderDiscriminatedAssociation(NavigablePath fetchPath, DiscriminatedAssociationAttributeMapping fetchable, DomainResultCreationState creationState) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState creationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        creationStateImpl.getFromClauseAccess().resolveTableGroup(fetchPath, navigablePath -> {
            TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.fetchable.createTableGroupJoin(fetchPath, parentTableGroup, null, SqlAstJoinType.INNER, true, false, creationStateImpl);
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        return parent.generateFetchableFetch(this.fetchable, fetchPath, this.fetchable.getTiming(), false, null, creationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitFetchBuilderDiscriminatedAssociation that = (ImplicitFetchBuilderDiscriminatedAssociation)o;
        return this.fetchPath.equals(that.fetchPath) && this.fetchable.equals(that.fetchable);
    }

    public int hashCode() {
        int result = this.fetchPath.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        return result;
    }

    public String toString() {
        return "ImplicitFetchBuilderDiscriminatedAssociation(" + this.fetchPath + ")";
    }
}

