/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractDiscriminatorMapping
implements EntityDiscriminatorMapping {
    private final NavigableRole role;
    private final EntityPersister entityDescriptor;
    private final DiscriminatorType<?> discriminatorType;
    private final SessionFactoryImplementor sessionFactory;

    public AbstractDiscriminatorMapping(EntityPersister entityDescriptor, DiscriminatorType<?> discriminatorType, MappingModelCreationProcess creationProcess) {
        this.entityDescriptor = entityDescriptor;
        this.discriminatorType = discriminatorType;
        this.role = entityDescriptor.getNavigableRole().append("{discriminator}");
        this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
    }

    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public BasicType<?> getUnderlyingJdbcMappingType() {
        return this.discriminatorType.getUnderlyingType();
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.role;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.discriminatorType;
    }

    @Override
    public String getConcreteEntityNameForDiscriminatorValue(Object value) {
        return this.getEntityDescriptor().getSubclassForDiscriminatorValue(value);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.entityDescriptor;
    }

    @Override
    public MappingType getMappedType() {
        return this.getJdbcMapping();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, this.getUnderlyingJdbcMappingType(), tableGroup, null, creationState.getSqlAstCreationState());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.discriminatorType, navigablePath);
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, FetchParent fetchParent, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        return expressionResolver.resolveSqlSelection(this.resolveSqlExpression(navigablePath, jdbcMappingToUse, tableGroup, creationState), jdbcMappingToUse.getJdbcJavaType(), fetchParent, creationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public BasicFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, this.getUnderlyingJdbcMappingType(), tableGroup, fetchParent, creationState.getSqlAstCreationState());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, fetchTiming, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, this.getUnderlyingJdbcMappingType(), tableGroup, null, creationState.getSqlAstCreationState());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, this.getUnderlyingJdbcMappingType(), tableGroup, null, creationState.getSqlAstCreationState()), this.getJdbcMapping());
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(this.disassemble(domainValue, session), this);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }
}

