/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.PessimisticLockException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2DurationIntervalSecondJdbcType;
import org.hibernate.dialect.H2SqlAstTranslator;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.H2FinalTableIdentityColumnSupport;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.H2V1SequenceSupport;
import org.hibernate.dialect.sequence.H2V2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.NullOrdering;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorH2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.InstantJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class H2Dialect
extends Dialect {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(H2Dialect.class);
    private final LimitHandler limitHandler;
    private final boolean ansiSequence;
    private final boolean cascadeConstraints;
    private final boolean useLocalTime;
    private final SequenceInformationExtractor sequenceInformationExtractor;
    private final String querySequenceString;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String message;
        int idx;
        if (sqle.getSQLState().startsWith("23") && (idx = (message = sqle.getMessage()).indexOf("violation: ")) > 0) {
            String constraintName = message.substring(idx + "violation: ".length());
            if (sqle.getSQLState().equals("23506")) {
                constraintName = constraintName.substring(1, constraintName.indexOf(":"));
            }
            return constraintName;
        }
        return null;
    });

    public H2Dialect(DialectResolutionInfo info) {
        this(H2Dialect.parseVersion(info));
        this.registerKeywords(info);
    }

    public H2Dialect() {
        this(SimpleDatabaseVersion.ZERO_VERSION);
    }

    public H2Dialect(DatabaseVersion version) {
        super(version);
        LimitHandler limitHandler = this.limitHandler = version.isSameOrAfter(1, 4, 195) ? OffsetFetchLimitHandler.INSTANCE : LimitOffsetLimitHandler.INSTANCE;
        if (version.isBefore(1, 2, 139)) {
            LOG.unsupportedMultiTableBulkHqlJpaql(version.getMajor(), version.getMinor(), version.getMicro());
        }
        this.ansiSequence = version.isSameOrAfter(1, 4, 200);
        this.cascadeConstraints = version.isSameOrAfter(1, 4, 200);
        this.useLocalTime = version.isSameOrAfter(1, 4, 200);
        if (version.isSameOrAfter(1, 4, 32)) {
            this.sequenceInformationExtractor = version.isSameOrAfter(1, 4, 201) ? SequenceInformationExtractorLegacyImpl.INSTANCE : SequenceInformationExtractorH2DatabaseImpl.INSTANCE;
            this.querySequenceString = "select * from INFORMATION_SCHEMA.SEQUENCES";
        } else {
            this.sequenceInformationExtractor = SequenceInformationExtractorNoOpImpl.INSTANCE;
            this.querySequenceString = null;
        }
    }

    private static DatabaseVersion parseVersion(DialectResolutionInfo info) {
        return DatabaseVersion.make(info.getMajor(), info.getMinor(), H2Dialect.parseBuildId(info));
    }

    private static int parseBuildId(DialectResolutionInfo info) {
        String databaseVersion = info.getDatabaseVersion();
        if (databaseVersion == null) {
            return 0;
        }
        String[] bits = databaseVersion.split("[. ]");
        return bits.length > 2 ? Integer.parseInt(bits[2]) : 0;
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    public boolean supportsStandardArrays() {
        return this.getVersion().isSameOrAfter(2);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 2: {
                return this.getVersion().isBefore(2) ? this.columnType(3) : super.columnType(sqlTypeCode);
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case 1: {
                return "char";
            }
            case -9: 
            case 12: 
            case 4001: 
            case 4002: {
                return "varchar";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "varbinary";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        if (this.getVersion().isBefore(2)) {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2003, "array", this));
        }
        if (this.getVersion().isSameOrAfter(1, 4, 197)) {
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
            ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
            if (this.getVersion().isSameOrAfter(1, 4, 198)) {
                ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3100, "interval second($p,$s)", this));
            }
        }
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(3003, InstantJdbcType.INSTANCE);
        if (this.getVersion().isSameOrAfter(1, 4, 197)) {
            jdbcTypeRegistry.addDescriptorIfAbsent(UUIDJdbcType.INSTANCE);
        }
        if (this.getVersion().isSameOrAfter(1, 4, 198)) {
            jdbcTypeRegistry.addDescriptorIfAbsent(H2DurationIntervalSecondJdbcType.INSTANCE);
        }
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public boolean hasOddDstBehavior() {
        return this.getVersion().isSameOrAfter(1, 4, 200);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(queryEngine);
        functionFactory.aggregates(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.pi();
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.rand();
        functionFactory.truncate();
        functionFactory.soundex();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitAndOr();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayOfWeekMonthYear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        if (this.useLocalTime) {
            functionFactory.localtimeLocaltimestamp();
        }
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.octetLength();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.chr_char();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.trim1();
        functionFactory.concat_pipeOperator();
        functionFactory.nowCurdateCurtime();
        functionFactory.sysdate();
        functionFactory.insert();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        if (this.getVersion().isSame(1, 4, 200)) {
            functionFactory.format_toChar();
        } else {
            functionFactory.format_formatdatetime();
        }
        functionFactory.rownum();
        if (this.getVersion().isSameOrAfter(1, 4, 200)) {
            functionFactory.windowFunctions();
            if (this.getVersion().isSameOrAfter(2)) {
                functionFactory.listagg(null);
                functionFactory.inverseDistributionOrderedSetAggregates();
                functionFactory.hypotheticalOrderedSetAggregates();
            } else {
                functionFactory.listagg_groupConcat();
            }
        } else {
            functionFactory.listagg_groupConcat();
        }
    }

    @Override
    public void augmentPhysicalTableTypes(List<String> tableTypesList) {
        if (this.getVersion().isSameOrAfter(2)) {
            tableTypesList.add("BASE TABLE");
        }
    }

    @Override
    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        switch (columnTypeName) {
            case "FLOAT(24)": {
                return 7;
            }
        }
        return super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == 6 && "DOUBLE PRECISION".equals(columnTypeName)) {
            return jdbcTypeRegistry.getDescriptor(8);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        switch (baseTypeName) {
            case "CHARACTER VARYING": {
                return 12;
            }
        }
        return super.resolveSqlTypeCode(typeName, baseTypeName, typeConfiguration);
    }

    @Override
    public int getMaxVarcharLength() {
        return 0x100000;
    }

    @Override
    public String currentTime() {
        return this.useLocalTime ? "localtime" : super.currentTime();
    }

    @Override
    public String currentTimestamp() {
        return this.useLocalTime ? "localtimestamp" : super.currentTimestamp();
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new H2SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.SECOND ? "(" + super.extractPattern(unit) + "+extract(nanosecond from ?2)/1e9)" : super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        return "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        return "datediff(?1,?2,?3)";
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS) && this.supportsTimeWithTimeZoneLiteral()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeWithTimeZoneLiteral()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, date, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, date);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeWithTimeZoneLiteral()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, calendar, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, calendar);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean supportsTimeWithTimeZoneLiteral() {
        return this.getVersion().isSameOrAfter(1, 4, 200);
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return !this.supportsIfExistsBeforeTableName();
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public String getCascadeConstraintsString() {
        return this.cascadeConstraints ? " cascade " : super.getCascadeConstraintsString();
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.ansiSequence ? H2V2SequenceSupport.INSTANCE : H2V1SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.sequenceInformationExtractor;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            switch (errorCode) {
                case 40001: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 50200: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 90006: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.ALIAS;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(1, 4, 200);
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion().isSameOrAfter(1, 4, 198);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isSameOrAfter(2) ? H2FinalTableIdentityColumnSupport.INSTANCE : H2IdentityColumnSupport.INSTANCE;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        return position;
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        if (this.getVersion().isSame(1, 4, 200)) {
            appender.appendSql(OracleDialect.datetimeFormat(format, true, true).result());
        } else {
            appender.appendSql(new Replacer(format, "'", "''").replace("e", "u").replace("xxx", "XXX").replace("xx", "XX").replace("x", "X").result());
        }
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case WEEK: {
                return "iso_week";
            }
        }
        return unit.toString();
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }
}

