/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.LockMode;
import org.hibernate.dialect.DB2SqlAstTranslator;
import org.hibernate.dialect.DB2zDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2zSqlAstTranslator<T extends JdbcOperation>
extends DB2SqlAstTranslator<T> {
    private final DatabaseVersion version;

    public DB2zSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement, DatabaseVersion version) {
        super(sessionFactory, statement);
        this.version = version;
    }

    @Override
    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && (this.useOffsetFetchClause(queryPart) && !this.isRowsOnlyFetchClauseType(queryPart) || this.version.isBefore(12) && queryPart.isRoot() && this.hasLimit() || this.version.isBefore(12) && queryPart.getFetchClauseExpression() != null && !(queryPart.getFetchClauseExpression() instanceof Literal));
    }

    @Override
    protected boolean supportsOffsetClause() {
        return this.version.isSameOrAfter(12);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    @Override
    protected boolean renderPrimaryTableReference(TableGroup tableGroup, LockMode lockMode) {
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        if (tableReference instanceof NamedTableReference) {
            return this.renderNamedTableReference((NamedTableReference)tableReference, lockMode);
        }
        this.append("table ");
        tableReference.accept(this);
        return false;
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        this.append('(');
        tableReference.getFunctionExpression().accept(this);
        this.append(')');
        this.renderDerivedTableReference(tableReference);
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2zDialect.DB2_LUW_VERSION9;
    }
}

