/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.jboss.logging.Logger;

public class CopyIdentifierComponentSecondPass
extends FkSecondPass {
    private static final Logger log = Logger.getLogger(CopyIdentifierComponentSecondPass.class);
    private final String referencedEntityName;
    private final String propertyName;
    private final Component component;
    private final MetadataBuildingContext buildingContext;
    private final AnnotatedJoinColumn[] joinColumns;

    public CopyIdentifierComponentSecondPass(Component comp, String referencedEntityName, String propertyName, AnnotatedJoinColumn[] joinColumns, MetadataBuildingContext buildingContext) {
        super(comp, joinColumns);
        this.component = comp;
        this.referencedEntityName = referencedEntityName;
        this.propertyName = propertyName;
        this.buildingContext = buildingContext;
        this.joinColumns = joinColumns;
    }

    @Override
    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public boolean isInPrimaryKey() {
        return true;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        AnnotatedJoinColumn joinColumn;
        String referencedColumnName;
        PersistentClass referencedPersistentClass = persistentClasses.get(this.referencedEntityName);
        if (referencedPersistentClass == null) {
            throw new AnnotationException("Unknown entity name '" + this.referencedEntityName + "'");
        }
        KeyValue identifier = referencedPersistentClass.getIdentifier();
        if (!(identifier instanceof Component)) {
            throw new AnnotationException("Missing 'value' in '@MapsId' annotation of association '" + this.propertyName + "' of entity '" + this.component.getOwner().getEntityName() + "' with composite identifier type ('@MapsId' must specify a property of the '@EmbeddedId' class which has the foreign key of '" + this.referencedEntityName + "')");
        }
        Component referencedComponent = (Component)identifier;
        boolean isExplicitReference = true;
        HashMap<String, AnnotatedJoinColumn> columnByReferencedName = CollectionHelper.mapOfSize(this.joinColumns.length);
        AnnotatedJoinColumn[] annotatedJoinColumnArray = this.joinColumns;
        int n = annotatedJoinColumnArray.length;
        for (int i = 0; i < n && (referencedColumnName = (joinColumn = annotatedJoinColumnArray[i]).getReferencedColumn()) != null && !BinderHelper.isEmptyAnnotationValue(referencedColumnName); ++i) {
            columnByReferencedName.put(referencedColumnName.toLowerCase(Locale.ROOT), joinColumn);
        }
        if (columnByReferencedName.isEmpty()) {
            isExplicitReference = false;
            for (int i = 0; i < this.joinColumns.length; ++i) {
                columnByReferencedName.put(String.valueOf(i), this.joinColumns[i]);
            }
        }
        MutableInteger index = new MutableInteger();
        for (Property referencedProperty : referencedComponent.getProperties()) {
            Property property;
            if (referencedProperty.isComposite()) {
                property = this.createComponentProperty(referencedPersistentClass, isExplicitReference, columnByReferencedName, index, referencedProperty);
                this.component.addProperty(property);
                continue;
            }
            property = this.createSimpleProperty(referencedPersistentClass, isExplicitReference, columnByReferencedName, index, referencedProperty);
            this.component.addProperty(property);
        }
    }

    private Property createComponentProperty(PersistentClass referencedPersistentClass, boolean isExplicitReference, Map<String, AnnotatedJoinColumn> columnByReferencedName, MutableInteger index, Property referencedProperty) {
        Property property = new Property();
        property.setName(referencedProperty.getName());
        property.setPersistentClass(this.component.getOwner());
        property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
        Component value = new Component(this.buildingContext, this.component.getOwner());
        property.setValue(value);
        Component referencedValue = (Component)referencedProperty.getValue();
        value.setTypeName(referencedValue.getTypeName());
        value.setTypeParameters(referencedValue.getTypeParameters());
        value.setComponentClassName(referencedValue.getComponentClassName());
        for (Property referencedComponentProperty : referencedValue.getProperties()) {
            Property componentProperty;
            if (referencedComponentProperty.isComposite()) {
                componentProperty = this.createComponentProperty(referencedValue.getOwner(), isExplicitReference, columnByReferencedName, index, referencedComponentProperty);
                value.addProperty(componentProperty);
                continue;
            }
            componentProperty = this.createSimpleProperty(referencedValue.getOwner(), isExplicitReference, columnByReferencedName, index, referencedComponentProperty);
            value.addProperty(componentProperty);
        }
        return property;
    }

    private Property createSimpleProperty(PersistentClass referencedPersistentClass, boolean isExplicitReference, Map<String, AnnotatedJoinColumn> columnByReferencedName, MutableInteger index, Property referencedProperty) {
        Property property = new Property();
        property.setName(referencedProperty.getName());
        property.setPersistentClass(this.component.getOwner());
        property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
        BasicValue value = new BasicValue(this.buildingContext, this.component.getTable());
        property.setValue(value);
        SimpleValue referencedValue = (SimpleValue)referencedProperty.getValue();
        ((SimpleValue)value).copyTypeFrom(referencedValue);
        if (this.joinColumns[0].isNameDeferred()) {
            this.joinColumns[0].copyReferencedStructureAndCreateDefaultJoinColumns(referencedPersistentClass, referencedValue, value);
        } else {
            for (Selectable selectable : referencedValue.getSelectables()) {
                AnnotatedJoinColumn joinColumn;
                if (!(selectable instanceof Column)) {
                    log.debug((Object)"Encountered formula definition; skipping");
                    continue;
                }
                Column column = (Column)selectable;
                String logicalColumnName = null;
                if (isExplicitReference) {
                    logicalColumnName = column.getName();
                    joinColumn = columnByReferencedName.get(logicalColumnName.toLowerCase(Locale.ROOT));
                } else {
                    joinColumn = columnByReferencedName.get(String.valueOf(index.get()));
                    index.getAndIncrement();
                }
                if (joinColumn == null && !this.joinColumns[0].isNameDeferred()) {
                    throw new AnnotationException("Property '" + this.propertyName + "' of entity '" + this.component.getOwner().getEntityName() + "' must have a '@JoinColumn' which references the foreign key column '" + logicalColumnName + "'");
                }
                Object columnName = joinColumn == null || joinColumn.isNameDeferred() ? "tata_" + column.getName() : joinColumn.getName();
                Database database = this.buildingContext.getMetadataCollector().getDatabase();
                PhysicalNamingStrategy physicalNamingStrategy = this.buildingContext.getBuildingOptions().getPhysicalNamingStrategy();
                Identifier explicitName = database.toIdentifier((String)columnName);
                Identifier physicalName = physicalNamingStrategy.toPhysicalColumnName(explicitName, database.getJdbcEnvironment());
                ((SimpleValue)value).addColumn(new Column(physicalName.render(database.getDialect())));
                if (joinColumn != null) {
                    this.applyComponentColumnSizeValueToJoinColumn(column, joinColumn);
                    joinColumn.linkWithValue(value);
                }
                column.setValue(value);
            }
        }
        return property;
    }

    private void applyComponentColumnSizeValueToJoinColumn(Column column, AnnotatedJoinColumn joinColumn) {
        Column mappingColumn = joinColumn.getMappingColumn();
        mappingColumn.setLength(column.getLength());
        mappingColumn.setPrecision(column.getPrecision());
        mappingColumn.setScale(column.getScale());
    }
}

