/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.LockModeType;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;

public enum LockMode {
    NONE(0, "none"),
    READ(5, "read"),
    OPTIMISTIC(6, "optimistic"),
    OPTIMISTIC_FORCE_INCREMENT(7, "optimistic_force_increment"),
    WRITE(10, "write"),
    UPGRADE_NOWAIT(10, "upgrade-nowait"),
    UPGRADE_SKIPLOCKED(10, "upgrade-skiplocked"),
    PESSIMISTIC_READ(12, "pessimistic_read"),
    PESSIMISTIC_WRITE(13, "pessimistic_write"),
    PESSIMISTIC_FORCE_INCREMENT(17, "pessimistic_force_increment");

    private final int level;
    private final String externalForm;

    private LockMode(int level, String externalForm) {
        this.level = level;
        this.externalForm = externalForm;
    }

    public static LockMode fromJpaLockMode(LockModeType lockMode) {
        return LockModeTypeHelper.getLockMode(lockMode);
    }

    public static LockModeType toJpaLockMode(LockMode lockMode) {
        return LockModeTypeHelper.getLockModeType(lockMode);
    }

    public LockModeType toJpaLockMode() {
        return LockModeTypeHelper.getLockModeType(this);
    }

    public boolean greaterThan(LockMode mode) {
        return this.level > mode.level;
    }

    public boolean lessThan(LockMode mode) {
        return this.level < mode.level;
    }

    public String toExternalForm() {
        return this.externalForm;
    }

    public static LockMode fromExternalForm(String externalForm) {
        if (externalForm == null) {
            return NONE;
        }
        for (LockMode lockMode : LockMode.values()) {
            if (!lockMode.externalForm.equals(externalForm)) continue;
            return lockMode;
        }
        if (externalForm.equalsIgnoreCase("upgrade")) {
            return PESSIMISTIC_WRITE;
        }
        throw new IllegalArgumentException("Unable to interpret LockMode reference from incoming external form : " + externalForm);
    }
}

