/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.ModulesServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.ServiceValueCaptorServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceValueRegistry;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.GlobalConfigurationServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.KeyAffinityServiceFactoryServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.LazyCacheServiceConfigurator;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.lifecycle.WildFlyInfinispanModuleLifecycle;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.server.service.ProvidedIdentityCacheServiceConfigurator;
import org.wildfly.clustering.service.IdentityServiceConfigurator;

public class CacheContainerServiceHandler
implements ResourceServiceHandler {
    private final ServiceValueRegistry<EmbeddedCacheManager> containerRegistry;
    private final ServiceValueRegistry<Cache<?, ?>> cacheRegistry;

    public CacheContainerServiceHandler(ServiceValueRegistry<EmbeddedCacheManager> containerRegistry, ServiceValueRegistry<Cache<?, ?>> cacheRegistry) {
        this.containerRegistry = containerRegistry;
        this.cacheRegistry = cacheRegistry;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        ServiceTarget target = context.getServiceTarget();
        new ModulesServiceConfigurator(CacheContainerComponent.MODULES.getServiceName(address), (Attribute)CacheContainerResourceDefinition.ListAttribute.MODULES, Collections.singletonList(Module.forClass(WildFlyInfinispanModuleLifecycle.class))).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        GlobalConfigurationServiceConfigurator configBuilder = new GlobalConfigurationServiceConfigurator(address);
        configBuilder.configure(context, model).build(target).install();
        CacheContainerServiceConfigurator containerBuilder = new CacheContainerServiceConfigurator(address, this.cacheRegistry).configure(context, model);
        containerBuilder.build(target).install();
        new ServiceValueCaptorServiceConfigurator(this.containerRegistry.add(containerBuilder.getServiceName())).build(target).install();
        new KeyAffinityServiceFactoryServiceConfigurator(address).build(target).install();
        new BinderServiceConfigurator(InfinispanBindingFactory.createCacheContainerBinding(name), containerBuilder.getServiceName()).build(target).install();
        String defaultCache = CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asString(null);
        if (defaultCache != null) {
            for (Map.Entry<InfinispanCacheRequirement, Capability> entry : CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.entrySet()) {
                new IdentityServiceConfigurator(entry.getValue().getServiceName(address), entry.getKey().getServiceName(context, name, defaultCache)).build(target).install();
            }
            if (!defaultCache.equals("default")) {
                ServiceName lazyCacheServiceName = CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CACHE).getServiceName(address).append(new String[]{"lazy"});
                new LazyCacheServiceConfigurator(lazyCacheServiceName, name, defaultCache).configure(context).build(target).install();
                new BinderServiceConfigurator(InfinispanBindingFactory.createCacheBinding(name, "default"), lazyCacheServiceName).build(target).install();
                new BinderServiceConfigurator(InfinispanBindingFactory.createCacheConfigurationBinding(name, "default"), CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CONFIGURATION).getServiceName(address)).build(target).install();
            }
            new ProvidedIdentityCacheServiceConfigurator(name, null, defaultCache).configure(context).build(target).install();
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        String defaultCache = CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asString(null);
        if (defaultCache != null) {
            new ProvidedIdentityCacheServiceConfigurator(name, null, defaultCache).remove(context);
            if (!defaultCache.equals("default")) {
                context.removeService(InfinispanBindingFactory.createCacheBinding(name, "default").getBinderServiceName());
                context.removeService(InfinispanBindingFactory.createCacheConfigurationBinding(name, "default").getBinderServiceName());
            }
            for (Capability capability : CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.values()) {
                context.removeService(capability.getServiceName(address));
            }
        }
        context.removeService(InfinispanBindingFactory.createCacheContainerBinding(name).getBinderServiceName());
        context.removeService(CacheContainerComponent.MODULES.getServiceName(address));
        for (Capability capability : EnumSet.allOf(CacheContainerResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
        context.removeService(new ServiceValueCaptorServiceConfigurator(this.containerRegistry.remove(CacheContainerResourceDefinition.Capability.CONTAINER.getServiceName(address))).getServiceName());
    }
}

