/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.group;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.NodeFactory;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.infinispan.group.AddressableNode;
import org.wildfly.clustering.server.infinispan.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.infinispan.group.CacheMembership;
import org.wildfly.clustering.server.infinispan.group.GroupListenerNotificationTask;
import org.wildfly.clustering.server.infinispan.group.SingletonMembership;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(observation=Listener.Observation.POST)
public class CacheGroup
implements Group<Address>,
AutoCloseable,
Function<GroupListener, ExecutorService> {
    private final Map<GroupListener, ExecutorService> listeners = new ConcurrentHashMap<GroupListener, ExecutorService>();
    private final Cache<?, ?> cache;
    private final NodeFactory<org.jgroups.Address> nodeFactory;
    private final SortedMap<Integer, Boolean> views = Collections.synchronizedSortedMap(new TreeMap());
    private final BlockingManager blocking;
    private final Executor executor;

    public CacheGroup(CacheGroupConfiguration config) {
        this.cache = config.getCache();
        this.nodeFactory = config.getMemberFactory();
        this.blocking = config.getBlockingManager();
        this.executor = this.blocking.asExecutor(this.getClass().getName());
        this.cache.getCacheManager().addListener((Object)this);
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        this.cache.getCacheManager().removeListener((Object)this);
        for (ExecutorService executor : this.listeners.values()) {
            this.shutdown(executor);
        }
        this.listeners.clear();
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getName() {
        GlobalConfiguration global = this.cache.getCacheManager().getCacheManagerConfiguration();
        TransportConfiguration transport = global.transport();
        return transport.transport() != null ? transport.clusterName() : global.cacheManagerName();
    }

    public Node getLocalMember() {
        return this.createNode(this.cache.getCacheManager().getAddress());
    }

    public Membership getMembership() {
        if (this.isSingleton()) {
            return new SingletonMembership(this.getLocalMember());
        }
        EmbeddedCacheManager manager = this.cache.getCacheManager();
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? new CacheMembership(manager.getAddress(), (CacheTopology)dist.getCacheTopology(), (NodeFactory<Address>)this) : new CacheMembership(manager, (NodeFactory<Address>)this);
    }

    public boolean isSingleton() {
        return this.cache.getAdvancedCache().getRpcManager() == null;
    }

    public Node createNode(Address address) {
        return this.nodeFactory.createNode((Object)CacheGroup.toJGroupsAddress(address));
    }

    public Address getAddress(Node node) {
        return node instanceof AddressableNode ? JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)((AddressableNode)node).getAddress()) : LocalModeAddress.INSTANCE;
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address == null || address == LocalModeAddress.INSTANCE) {
            return null;
        }
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }

    @Merged
    @ViewChanged
    public CompletionStage<Void> viewChanged(ViewChangedEvent event) {
        if (this.cache.getAdvancedCache().getDistributionManager() != null) {
            return this.blocking.runBlocking(() -> this.views.put(event.getViewId(), event.isMergeView()), (Object)event.getViewId());
        }
        CacheMembership previousMembership = new CacheMembership(event.getLocalAddress(), event.getOldMembers(), (NodeFactory<Address>)this);
        CacheMembership membership = new CacheMembership(event.getLocalAddress(), event.getNewMembers(), (NodeFactory<Address>)this);
        if (!this.listeners.isEmpty()) {
            this.executor.execute(new GroupListenerNotificationTask(this.listeners.entrySet(), previousMembership, membership, event.isMergeView()));
        }
        return CompletableFutures.completedNull();
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<?, ?> event) {
        int viewId = event.getCache().getAdvancedCache().getRpcManager().getTransport().getViewId();
        Address localAddress = event.getCache().getCacheManager().getAddress();
        CacheMembership previousMembership = new CacheMembership(localAddress, event.getWriteConsistentHashAtStart(), (NodeFactory<Address>)this);
        CacheMembership membership = new CacheMembership(localAddress, event.getWriteConsistentHashAtEnd(), (NodeFactory<Address>)this);
        this.executor.execute(() -> {
            Boolean status = (Boolean)this.views.get(viewId);
            boolean merged = status != null ? status : false;
            new GroupListenerNotificationTask(this.listeners.entrySet(), previousMembership, membership, merged).run();
            this.views.headMap(viewId).clear();
        });
        return CompletableFutures.completedNull();
    }

    public Registration register(GroupListener listener) {
        this.listeners.computeIfAbsent(listener, this);
        return () -> this.unregister(listener);
    }

    @Override
    public ExecutorService apply(GroupListener listener) {
        return new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD);
    }

    private void unregister(GroupListener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }
}

